/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.Document;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.action.ConfigurableActionBuilder;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.component.search.ISearchEngine;
import net.anwiba.commons.swing.component.search.action.IAdvancedSearchActionFactory;
import net.anwiba.commons.swing.component.search.action.NextAction;
import net.anwiba.commons.swing.component.search.action.PreviousAction;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.object.StringObjectFieldConfigurationBuilder;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class SearchComponent<C, R>
implements IComponentProvider {
    private JPanel contentPane;
    private final ISearchEngine<C, R> engine;
    private StringField stringField;
    private final JComponent[] components;
    private final IAdvancedSearchActionFactory<C> advancedSearchActionFactory;
    private final IFactory<String, C, RuntimeException> stringConditionFactory;

    public SearchComponent(ISearchEngine<C, R> engine, IFactory<String, C, RuntimeException> stringConditionFactory, JComponent ... components) {
        this(engine, stringConditionFactory, (IAdvancedSearchActionFactory<C>)null, components);
    }

    public SearchComponent(ISearchEngine<C, R> engine, IFactory<String, C, RuntimeException> stringConditionFactory, IAdvancedSearchActionFactory<C> advancedSearchActionFactory, JComponent ... components) {
        this.engine = engine;
        this.stringConditionFactory = stringConditionFactory;
        this.advancedSearchActionFactory = advancedSearchActionFactory;
        this.components = components;
    }

    @Override
    public JComponent getComponent() {
        if (this.contentPane == null) {
            StringField stringField;
            this.contentPane = new JPanel(new BorderLayout());
            this.contentPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
            JPanel controllPane = new JPanel(new FlowLayout(0));
            final ISearchEngine engine = this.engine;
            final PreviousAction previousAction = new PreviousAction(engine);
            previousAction.setEnabled(false);
            final NextAction nextAction = new NextAction(engine);
            nextAction.setEnabled(false);
            ObjectModel searchStringModel = new ObjectModel();
            StringObjectFieldConfigurationBuilder builder = (StringObjectFieldConfigurationBuilder)((StringObjectFieldConfigurationBuilder)((StringObjectFieldConfigurationBuilder)new StringObjectFieldConfigurationBuilder().setToolTipFactory((validationResult, context) -> "feature search condition")).setColumns(24)).setModel(searchStringModel);
            ObjectModel searchFeatureAcceptorModel = new ObjectModel();
            AbstractAction searchAction = new ConfigurableActionBuilder().setIcon((IGuiIcon)ContrastHightIcons.MEDIA_PLAYBACK_START).setTooltip("search").setTask((IBlock<InvocationTargetException>)((IBlock)() -> this.lambda$1(engine, (IObjectModel)searchFeatureAcceptorModel, searchStringModel))).build();
            final BooleanModel resetActionEnabledModel = new BooleanModel(!engine.getSearchResultsModel().isEmpty());
            AbstractAction resetAction = new ConfigurableActionBuilder().setIcon((IGuiIcon)ContrastHightIcons.EDIT_DELETE).setTooltip("reset").setEnabledModel((IBooleanModel)resetActionEnabledModel).setTask((IBlock<InvocationTargetException>)((IBlock)() -> engine.reset())).build();
            builder.addActionFactory((c, d, b) -> searchAction);
            if (this.advancedSearchActionFactory != null) {
                builder.addActionFactory((arg_0, arg_1, arg_2) -> this.lambda$4(searchStringModel, (IObjectModel)searchFeatureAcceptorModel, engine, arg_0, arg_1, arg_2));
            }
            builder.addClearAction("clear");
            builder.addActionFactory((c, d, b) -> previousAction);
            builder.addActionFactory((c, d, b) -> nextAction);
            builder.addActionFactory((c, d, b) -> resetAction);
            IObjectFieldConfiguration<String> configuration = builder.build();
            this.stringField = stringField = new StringField(configuration);
            IFactory<String, C, RuntimeException> stringConditionFactory = this.stringConditionFactory;
            engine.getSearchResultsModel().addListModelListener(new IChangeableListListener<R>(){

                public void objectsAdded(Iterable<Integer> indeces, Iterable<R> object) {
                    resetActionEnabledModel.set(!engine.getSearchResultsModel().isEmpty());
                }

                public void objectsRemoved(Iterable<Integer> indeces, Iterable<R> object) {
                    resetActionEnabledModel.set(!engine.getSearchResultsModel().isEmpty());
                }

                public void objectsUpdated(Iterable<Integer> indeces, Iterable<R> oldObjects, Iterable<R> newObjects) {
                    resetActionEnabledModel.set(!engine.getSearchResultsModel().isEmpty());
                }

                public void objectsChanged(Iterable<R> oldObjects, Iterable<R> newObjects) {
                    resetActionEnabledModel.set(!engine.getSearchResultsModel().isEmpty());
                }
            });
            searchStringModel.addChangeListener(new IChangeableObjectListener((IObjectModel)searchFeatureAcceptorModel, searchStringModel, engine, stringConditionFactory){
                private final /* synthetic */ IObjectModel val$searchFeatureAcceptorModel;
                private final /* synthetic */ ObjectModel val$searchStringModel;
                private final /* synthetic */ ISearchEngine val$engine;
                private final /* synthetic */ IFactory val$stringConditionFactory;
                {
                    this.val$searchFeatureAcceptorModel = iObjectModel;
                    this.val$searchStringModel = objectModel;
                    this.val$engine = iSearchEngine;
                    this.val$stringConditionFactory = iFactory;
                }

                public void objectChanged() {
                    this.val$searchFeatureAcceptorModel.set(null);
                    if (StringUtilities.isNullOrEmpty((String)((String)this.val$searchStringModel.get()))) {
                        return;
                    }
                    this.val$engine.search(this.val$stringConditionFactory.create((Object)((String)this.val$searchStringModel.get())));
                }
            });
            engine.getSearchResultsModel().addListModelListener(new IChangeableListListener<R>(){

                public void objectsAdded(Iterable<Integer> indeces, Iterable<R> object) {
                    this.updateComponent();
                }

                public void objectsRemoved(Iterable<Integer> indeces, Iterable<R> object) {
                    this.updateComponent();
                }

                public void objectsUpdated(Iterable<Integer> indeces, Iterable<R> oldObjects, Iterable<R> newObjects) {
                    this.updateComponent();
                }

                public void objectsChanged(Iterable<R> oldObjects, Iterable<R> newObjects) {
                    this.updateComponent();
                }

                private synchronized void updateComponent() {
                    final boolean isValid = !engine.getSearchResultsModel().isEmpty() || engine.getCondition() == null;
                    final boolean hasPrevious = engine.hasPrevious();
                    final boolean hasNext = engine.hasNext();
                    GuiUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            stringField.getComponent().setBackground(isValid ? Color.WHITE : Color.RED);
                            stringField.getComponent().setForeground(isValid ? Color.BLACK : Color.WHITE);
                            previousAction.setEnabled(hasPrevious);
                            nextAction.setEnabled(hasNext);
                        }
                    });
                }
            });
            engine.getResultCursorModel().addChangeListener(new IChangeableObjectListener(){

                public void objectChanged() {
                    final boolean hasPrevious = engine.hasPrevious();
                    final boolean hasNext = engine.hasNext();
                    GuiUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            previousAction.setEnabled(hasPrevious);
                            nextAction.setEnabled(hasNext);
                        }
                    });
                }
            });
            JComponent[] jComponentArray = this.components;
            int n = this.components.length;
            int n2 = 0;
            while (n2 < n) {
                JComponent component = jComponentArray[n2];
                controllPane.add(component);
                ++n2;
            }
            this.contentPane.add(this.createSearchField(stringField), "North");
            this.contentPane.add((Component)controllPane, "Center");
        }
        return this.contentPane;
    }

    private Component createSearchField(StringField stringField) {
        JPanel searchPanel = new JPanel(new GridLayout(1, 1));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        searchPanel.add(stringField.getComponent());
        return searchPanel;
    }

    public void grapFocus() {
        if (this.stringField != null) {
            this.stringField.getComponent().grabFocus();
        }
    }

    private /* synthetic */ void lambda$1(ISearchEngine iSearchEngine, IObjectModel iObjectModel, ObjectModel objectModel) throws InvocationTargetException {
        iSearchEngine.reset();
        iSearchEngine.search(Optional.ofNullable(iObjectModel.get()).orElseGet(() -> this.stringConditionFactory.create((Object)((String)objectModel.get()))));
    }

    private /* synthetic */ AbstractAction lambda$4(ObjectModel objectModel, IObjectModel iObjectModel, ISearchEngine iSearchEngine, IObjectModel context, Document document, IBlock clearBlock) throws RuntimeException {
        return this.advancedSearchActionFactory.create((IObjectReceiver<String>)objectModel, iObjectModel, iSearchEngine);
    }
}

