/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.dialog.AbstractDialog;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.IDialogConfiguration;
import net.anwiba.commons.swing.dialog.pane.IContentPanel;

public class ConfigurableDialog
extends AbstractDialog {
    private final IContentPanel contentPane;
    private final IObjectModel<DataState> dataStateModel;

    public ConfigurableDialog(Window owner, IDialogConfiguration configuration) {
        this(owner, configuration, configuration.getContentPaneBuilder().setOwner(owner).build());
    }

    public ConfigurableDialog(Window owner, IDialogConfiguration configuration, IContentPanel contentPane) {
        super(owner, configuration.getWindowPreferences(), configuration.getPreferdSize(), configuration.getTitle(), configuration.getMessage(), configuration.getIcon(), configuration.isMessagePanelEnabled(), configuration.getDialogType(), configuration.getActionButtonTextFactory(), configuration.getAdditionalActionFactories(), contentPane.getDataStateModel(), configuration.getModalityType());
        this.setIconImage(configuration.getImage());
        this.contentPane = contentPane;
        this.setContentPane(this.contentPane.getComponent());
        this.dataStateModel = this.contentPane.getDataStateModel();
        this.dataStateModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ConfigurableDialog.this.checkButton((DataState)((Object)ConfigurableDialog.this.dataStateModel.get()));
            }
        });
        this.checkButton((DataState)((Object)this.dataStateModel.get()));
        final IObjectModel<IMessage> messageModel = this.contentPane.getMessageModel();
        messageModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ConfigurableDialog.this.setMessage((IMessage)messageModel.get());
            }
        });
        this.dataStateModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ConfigurableDialog.this.setMessage((IMessage)messageModel.get());
            }
        });
        this.setMessage((IMessage)messageModel.get());
        this.setResizable(configuration.isResizeable());
        int dialogCloseKeyEvent = configuration.getDialogCloseKeyEvent();
        if (dialogCloseKeyEvent != 0) {
            KeyStroke stroke = KeyStroke.getKeyStroke(dialogCloseKeyEvent, 0);
            JRootPane pane = this.getRootPane();
            pane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigurableDialog.this.setVisible(false);
                }
            }, stroke, 2);
        }
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.locate();
        }
        super.setVisible(value);
    }

    @Override
    protected boolean apply() {
        return this.contentPane.apply();
    }

    @Override
    protected boolean tryOut() {
        return this.contentPane.tryOut();
    }

    @Override
    protected boolean cancel() {
        return this.contentPane.cancel();
    }

    @Override
    protected void close() {
        this.contentPane.close();
        super.close();
    }
}

