/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Component;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.exception.ExceptionDialog;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icon.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class MessageDialogLauncher {
    private final MessageBuilder builder = new MessageBuilder();
    private String title = "Title";
    GuiIcon icon = GuiIcons.EMPTY_ICON;
    DialogType dialogType = DialogType.CLOSE;

    public MessageDialogLauncher icon(GuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public MessageDialogLauncher closeButtonDialog() {
        this.dialogType = DialogType.CLOSE;
        return this;
    }

    public MessageDialogLauncher cancleOkButtonDialog() {
        this.dialogType = DialogType.CANCEL_OK;
        return this;
    }

    public MessageDialogLauncher dialogType(DialogType dialogType) {
        this.dialogType = dialogType;
        return this;
    }

    public MessageDialogLauncher title(String title) {
        this.title = title;
        return this;
    }

    public MessageDialogLauncher text(String text) {
        this.builder.setText(text);
        return this;
    }

    public MessageDialogLauncher description(String description) {
        this.builder.setDescription(description);
        return this;
    }

    public MessageDialogLauncher throwable(Throwable throwable) {
        this.builder.setThrowable(throwable);
        return this;
    }

    public MessageDialogLauncher type(MessageType messageType) {
        this.builder.setType(messageType);
        return this;
    }

    public MessageDialogLauncher error() {
        this.builder.setError();
        return this;
    }

    public MessageDialogLauncher info() {
        this.builder.setInfo();
        return this;
    }

    public MessageDialogLauncher warning() {
        this.builder.setWarning();
        return this;
    }

    public IDialogResult launch(Component component) {
        return this.launch(component == null ? null : SwingUtilities.windowForComponent(component));
    }

    public IDialogResult launch(Window owner) {
        ObjectModel model = new ObjectModel();
        IMessage message = this.builder.build();
        GuiUtilities.invokeAndWait(() -> this.lambda$0(owner, message, (IObjectModel)model));
        return (IDialogResult)model.get();
    }

    private static MessageDialog create(Window owner, String title, IMessage message, Icon icon, DialogType dialogType) {
        if (message instanceof ExceptionMessage) {
            return new ExceptionDialog(owner, (ExceptionMessage)message);
        }
        MessageDialog dialog = new MessageDialog(owner, title, message, icon, dialogType);
        dialog.locate();
        return dialog;
    }

    private /* synthetic */ void lambda$0(Window window, IMessage iMessage, IObjectModel iObjectModel) {
        MessageDialog dialog = MessageDialogLauncher.create(window, this.title, iMessage, this.icon.getLargeIcon(), this.dialogType);
        dialog.setVisible(true);
        iObjectModel.set((Object)dialog.getResult());
    }
}

