/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Color;
import javax.swing.Icon;
import net.anwiba.commons.message.IMessageTypeVisitor;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.swing.icon.GuiIconSize;
import net.anwiba.commons.swing.icon.GuiIcons;

public class MessageTypeUI {
    public static Icon getIcon(MessageType messageType, GuiIconSize size) {
        return MessageTypeUI.getIcon(messageType, null, size);
    }

    public static Icon getIcon(MessageType messageType, final Icon defaultIcon, final GuiIconSize size) {
        IMessageTypeVisitor<Icon> visitor = new IMessageTypeVisitor<Icon>(){

            public Icon visitInfo() {
                return GuiIcons.INFORMATION_ICON.getIcon(size);
            }

            public Icon visitError() {
                return GuiIcons.ERROR_ICON.getIcon(size);
            }

            public Icon visitWarning() {
                return GuiIcons.WARNING_ICON.getIcon(size);
            }

            public Icon visitDefault() {
                return defaultIcon;
            }

            public Icon visitQuery() {
                return GuiIcons.QUERY_ICON.getIcon(size);
            }
        };
        return (Icon)messageType.accept((IMessageTypeVisitor)visitor);
    }

    public static Color getColor(MessageType messageType) {
        IMessageTypeVisitor<Color> visitor = new IMessageTypeVisitor<Color>(){

            public Color visitInfo() {
                return Color.BLUE;
            }

            public Color visitError() {
                return Color.RED;
            }

            public Color visitWarning() {
                return Color.ORANGE;
            }

            public Color visitDefault() {
                return Color.BLACK;
            }

            public Color visitQuery() {
                return Color.BLACK;
            }
        };
        return (Color)messageType.accept((IMessageTypeVisitor)visitor);
    }
}

