/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.tabbed;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.swing.dialog.tabbed.AbstractNoneEditTabbedDialogTab;
import net.anwiba.commons.swing.icon.GuiIcons;

public class TextDialogTab
extends AbstractNoneEditTabbedDialogTab {
    public TextDialogTab(String header, String text) {
        this(header, null, GuiIcons.INFORMATION_ICON.getLargeIcon(), header, text);
    }

    public TextDialogTab(String name, IMessage message, Icon icon, String header, String text) {
        super(name, message, icon);
        JPanel component = new JPanel();
        component.setLayout(new GridLayout(1, 1));
        String textString = this.createText(header, text);
        JEditorPane textArea = new JEditorPane("text/html", textString);
        textArea.setCaretPosition(0);
        textArea.setMinimumSize(new Dimension(200, 100));
        textArea.setPreferredSize(new Dimension(200, 100));
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        component.add(scrollPane);
        this.setComponent(component);
    }

    private String createText(String header, String text) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        if (header != null) {
            builder.append("<H2>");
            builder.append(header);
            builder.append("</H2>");
        }
        builder.append(text);
        builder.append("</body><html>");
        return builder.toString();
    }
}

