/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.preference.SplitPanePreferences;

public class SplitPanePreferenceUpdaterListener
implements PropertyChangeListener,
HierarchyListener {
    private final JSplitPane splitPane;
    private int dividerLocation;
    private final SplitPanePreferences splitPanePreferences;

    SplitPanePreferenceUpdaterListener(JSplitPane splitPane, SplitPanePreferences splitPanePreferences) {
        this.splitPane = splitPane;
        this.splitPanePreferences = splitPanePreferences;
        this.dividerLocation = splitPane.getDividerLocation();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent event) {
        int location;
        if ("dividerLocation".equals(event.getPropertyName()) && (location = this.splitPane.getDividerLocation()) != this.dividerLocation) {
            this.dividerLocation = location;
            this.splitPanePreferences.setDividerLocation(location);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        if ((event.getChangeFlags() & 1L) != 0L && event.getChangedParent() == null) {
            this.splitPane.removeHierarchyListener(this);
            this.splitPane.removePropertyChangeListener(this);
        }
    }

    public static void connect(JSplitPane splitPane, IPreferences preferences) {
        SplitPanePreferences splitPanePreferences = new SplitPanePreferences(preferences.node(new String[]{"splitPane"}));
        splitPane.setDividerLocation(splitPanePreferences.getDividerLocation(splitPane.getDividerLocation()));
        SplitPanePreferenceUpdaterListener splitPaneUpdater = new SplitPanePreferenceUpdaterListener(splitPane, splitPanePreferences);
        splitPane.addPropertyChangeListener(splitPaneUpdater);
        splitPane.addHierarchyListener(splitPaneUpdater);
    }
}

