/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileFilter;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.anwiba.commons.http.HttpClientConnector;
import net.anwiba.commons.http.HttpRequestExecutorFactoryBuilder;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.image.IImageContainerFactory;
import net.anwiba.commons.image.IImageReader;
import net.anwiba.commons.image.ImageContainerFactory;
import net.anwiba.commons.image.ImageFileFilter;
import net.anwiba.commons.image.ImageReader;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IStreamConnector;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.ResourceReferenceHandler;
import net.anwiba.commons.swing.filechooser.FileFieldBuilder;
import net.anwiba.commons.swing.image.ImagePanel;
import net.anwiba.commons.swing.image.ImageScaleBehavior;
import net.anwiba.commons.swing.list.IListModel;
import net.anwiba.commons.swing.list.ObjectListComponent;
import net.anwiba.commons.swing.list.ObjectListComponentBuilder;
import net.anwiba.commons.swing.list.ObjectListComponentModel;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.ui.ObjectUiBuilder;
import net.anwiba.testing.demo.JFrames;
import org.junit.jupiter.api.Test;

public class ImagePanelDemo {
    private final IHttpRequestExecutorFactory httpRequestExcecutorFactory = new HttpRequestExecutorFactoryBuilder().useAlwaysANewConnection().build();
    private final ResourceReferenceHandler resourceReferenceHandler = new ResourceReferenceHandler((IStreamConnector)new HttpClientConnector(this.httpRequestExcecutorFactory));
    private final ImageContainerFactory imageContainerFactory = ImageContainerFactory.of(null, (IResourceReferenceHandler)this.resourceReferenceHandler);
    private final IImageReader imageReader = new ImageReader((IImageContainerFactory)this.imageContainerFactory, (IResourceReferenceHandler)this.resourceReferenceHandler, this.httpRequestExcecutorFactory);

    @Test
    public void showTifImage() throws Exception {
        IResourceReference resourceReference = this.create("image.tif");
        ObjectModel model = new ObjectModel();
        ImagePanel imagePanel = new ImagePanel((IImageContainerFactory)this.imageContainerFactory, this.imageReader, (IObjectModel)model, ImageScaleBehavior.SCALE_DOWN);
        JFrames.show((Duration)Duration.ofMinutes(5L), (JComponent)imagePanel, arg_0 -> ImagePanelDemo.lambda$showTifImage$0((IObjectModel)model, resourceReference, arg_0));
    }

    private IResourceReference create(String name) {
        return new ResourceReferenceFactory().create(this.getClass().getResource(name));
    }

    @Test
    public void showImage() throws Exception {
        ObjectModel model = new ObjectModel();
        ImagePanel imagePanel = new ImagePanel((IImageContainerFactory)this.imageContainerFactory, this.imageReader, (IObjectModel)model, ImageScaleBehavior.SCALE_DOWN);
        FileFieldBuilder builder = new FileFieldBuilder();
        IObjectField field = ((FileFieldBuilder)builder.addFolderOpenChooserAction(null).addClearAction(null)).setFolderValidator().build();
        final ObjectListComponentModel listModel = new ObjectListComponentModel(List.of());
        ObjectListComponent list = new ObjectListComponentBuilder().setModel((IListModel)listModel).setObjectUi(new ObjectUiBuilder().text(f -> f.getName()).tooltip(f -> f.toString()).build()).build();
        ISelectionModel selectionModel = list.getSelectionModel();
        final IObjectModel fileModel = field.getModel();
        fileModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                if (fileModel.isEmpty()) {
                    listModel.removeAll();
                    return;
                }
                Object[] files = ((File)fileModel.get()).listFiles(new FileFilter(){
                    ImageFileFilter filter = new ImageFileFilter();

                    @Override
                    public boolean accept(File pathname) {
                        return this.filter.accept(pathname);
                    }
                });
                if (files == null) {
                    listModel.removeAll();
                    return;
                }
                Arrays.sort(files);
                listModel.add(files);
            }
        });
        selectionModel.addSelectionListener((ISelectionListener)new ISelectionListener<File>((IObjectModel)model){
            final /* synthetic */ IObjectModel val$model;
            {
                this.val$model = iObjectModel;
            }

            public void selectionChanged(SelectionEvent<File> event) {
                Iterable selectedObjects = event.getSource().getSelectedObjects();
                Iterator iterator = selectedObjects.iterator();
                if (iterator.hasNext()) {
                    File next = (File)iterator.next();
                    this.val$model.set((Object)new ResourceReferenceFactory().create(next));
                } else {
                    this.val$model.set(null);
                }
            }
        });
        JPanel component = new JPanel();
        component.setMinimumSize(new Dimension(600, 320));
        component.setPreferredSize(new Dimension(600, 320));
        component.setLayout(new BorderLayout());
        component.add((Component)field.getComponent(), "North");
        JPanel imageContainer = new JPanel();
        imageContainer.setLayout(new GridLayout(1, 1));
        imageContainer.setMinimumSize(new Dimension(300, 300));
        imageContainer.setPreferredSize(new Dimension(300, 300));
        imageContainer.add((Component)imagePanel);
        JComponent listComponent = list.getComponent();
        listComponent.setMinimumSize(new Dimension(300, 300));
        listComponent.setPreferredSize(new Dimension(300, 300));
        component.add((Component)imageContainer, "Center");
        component.add((Component)listComponent, "West");
        JFrames.show((JComponent)component);
    }

    private static /* synthetic */ void lambda$showTifImage$0(IObjectModel model, IResourceReference resourceReference, JFrame frame) {
        try {
            Thread.sleep(500L);
            model.set((Object)resourceReference);
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

