/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.time.Duration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.graphic.ClosableGraphicsBuilder;
import net.anwiba.commons.graphic.IClosableGraphics;
import net.anwiba.commons.graphic.RenderingHintsBuilder;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.DoubleFieldBuilder;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.testing.demo.JFrames;
import org.junit.jupiter.api.Test;

public class StringPainterDemo {
    @Test
    public void showArial() throws Exception {
        this.show("Arial", 262);
    }

    @Test
    public void showMonospaced() throws Exception {
        this.show("Monospaced", 353);
    }

    public void show(String fontName, int distance) {
        final RenderingHints hints = new RenderingHintsBuilder().setColorRenderQuality().setStrokeControlNormalize().setAntiAliasingOn().setAlphaInterpolationQuality().setTextAntiAliasing(true).setDitheringEnabled().setRenderingQuality().build();
        Dimension size = new Dimension(600, 400);
        ObjectModel factorModel = new ObjectModel((Object)1.0);
        ObjectModel imageSizeModel = new ObjectModel((Object)size);
        ObjectModel imageModel = new ObjectModel((Object)this.createImage((Double)factorModel.get(), (Dimension)imageSizeModel.get(), hints, fontName, distance));
        IChangeableObjectListener listener = () -> this.lambda$show$2((IObjectModel)factorModel, (IObjectModel)imageSizeModel, (IObjectModel)imageModel, hints, fontName, distance);
        factorModel.addChangeListener(listener);
        imageSizeModel.addChangeListener(listener);
        JPanel toolPanel = new JPanel();
        toolPanel.setMinimumSize(new Dimension(10, 30));
        toolPanel.add(((DoubleFieldBuilder)((DoubleFieldBuilder)new DoubleFieldBuilder().setModel((IObjectModel)factorModel)).setToStringConverter(input -> String.format("%5.2f", input))).addSpinnerActions(0.5, 4.0, 0.01).build().getComponent());
        JPanel imagePanel = new JPanel((IObjectModel)imageModel){
            final /* synthetic */ IObjectModel val$imageModel;
            {
                this.val$imageModel = iObjectModel;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D graphics = (Graphics2D)g.create();
                try (IClosableGraphics graphic = new ClosableGraphicsBuilder(graphics, hints).build();){
                    graphic.drawImage((Image)this.val$imageModel.get(), 0, 0, null);
                }
            }
        };
        imagePanel.addComponentListener(new ComponentAdapter((IObjectModel)imageSizeModel){
            final /* synthetic */ IObjectModel val$imageSizeModel;
            {
                this.val$imageSizeModel = iObjectModel;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dimension = e.getComponent().getSize();
                if (dimension == null) {
                    return;
                }
                this.val$imageSizeModel.set((Object)dimension);
            }
        });
        imagePanel.setMinimumSize(size);
        imagePanel.setPreferredSize(size);
        imageModel.addChangeListener(() -> StringPainterDemo.lambda$show$6((IObjectModel)imageModel, imagePanel));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("North", toolPanel);
        panel.add("Center", imagePanel);
        JFrames.show((Duration)Duration.ofSeconds(10L), (JComponent)panel);
    }

    public BufferedImage createImage(double factor, Dimension size, RenderingHints hints, String fontName, int distance) {
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        AffineTransform transform = new AffineTransform();
        transform.translate(10.0, 10.0);
        transform.scale(factor, factor);
        try (IClosableGraphics graphic = new ClosableGraphicsBuilder((Graphics2D)image.getGraphics(), hints).build();){
            graphic.setClip(0, 0, size.width, size.height);
            graphic.setTransform(transform);
            graphic.setColor(Color.BLACK);
            graphic.setFont(new Font(fontName, 0, 16));
            graphic.drawString("Schienenverkehrsl\u00e4rm 24 Stunden - L", 3, 18);
            graphic.setFont(new Font(fontName, 1, 12));
            graphic.drawString("DEM", distance, 18);
        }
        return image;
    }

    private static /* synthetic */ void lambda$show$6(IObjectModel imageModel, JPanel imagePanel) {
        Optional.of((Object)((BufferedImage)imageModel.get())).consume(i -> GuiUtilities.invokeLater(() -> imagePanel.repaint()));
    }

    private /* synthetic */ void lambda$show$2(IObjectModel factorModel, IObjectModel imageSizeModel, IObjectModel imageModel, RenderingHints hints, String fontName, int distance) {
        Optional.of((Object)((Double)factorModel.get())).consume(f -> Optional.of((Object)((Dimension)imageSizeModel.get())).consume(d -> imageModel.set((Object)this.createImage((Double)factorModel.get(), (Dimension)d, hints, fontName, distance))));
    }
}

