/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.toolbar.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.anwiba.commons.swing.action.IActionContainerProvider;
import net.anwiba.commons.swing.action.JComboBoxActionProvider;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.toolbar.ToolBarDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupDescription;
import net.anwiba.commons.swing.toolbar.ToolBarManager;
import net.anwiba.testing.demo.JFrames;
import org.junit.jupiter.api.Test;

public class ToolBarManagerDemo {
    @Test
    public void demo() {
        ToolBarManager toolBarManager = new ToolBarManager();
        ToolBarDescription toolBarDescription0 = new ToolBarDescription("toolbar0", 4, true);
        ToolBarItemGroupDescription toolBarGroupDescription = new ToolBarItemGroupDescription("toolbargroup", 1);
        ToolBarItemGroupDescription toolBarToggelGroupDescription = new ToolBarItemGroupDescription("toolbargroup", 1, true);
        toolBarManager.add(new ToolBarItemConfiguration[]{new ToolBarItemConfiguration(new ToolBarItemDescription(toolBarDescription0, 2), (Action)new EmptyAction(null, GuiIcons.GLOBE_ICON.getSmallIcon()))});
        toolBarManager.add(new ToolBarItemConfiguration[]{new ToolBarItemConfiguration(new ToolBarItemDescription(toolBarDescription0, 1), (Action)new EmptyAction(null, GuiIcons.COLORIZE_ICON.getSmallIcon()))});
        toolBarManager.add(new ToolBarItemConfiguration[]{new ToolBarItemConfiguration(new ToolBarItemDescription(toolBarDescription0, toolBarGroupDescription, 1), (Action)new EmptyAction(null, GuiIcons.ERROR_ICON.getSmallIcon()))});
        ToolBarDescription toolBarDescription1 = new ToolBarDescription("toolbar1", 0, true);
        toolBarManager.add(new ToolBarItemConfiguration[]{this.createToolBarItemConfiguration(toolBarToggelGroupDescription, toolBarDescription1, GuiIcons.GLOBE_ICON.getSmallIcon())});
        toolBarManager.add(new ToolBarItemConfiguration[]{this.createToolBarItemConfiguration(toolBarToggelGroupDescription, toolBarDescription1, GuiIcons.COLORIZE_ICON.getSmallIcon())});
        toolBarManager.add(new ToolBarItemConfiguration[]{this.createToolBarItemConfiguration(toolBarToggelGroupDescription, toolBarDescription1, GuiIcons.INFORMATION_ICON.getSmallIcon())});
        ToolBarItemConfiguration toolBarItemConfiguration = this.getToolBarItemConfiguration();
        toolBarManager.add(new ToolBarItemConfiguration[]{toolBarItemConfiguration});
        JToolBar[] toolBars = toolBarManager.getJToolBars();
        JPanel container = new JPanel();
        for (JToolBar toolBar : toolBars) {
            container.add(toolBar);
        }
        JFrames.show((JComponent)container);
    }

    private ToolBarItemConfiguration createToolBarItemConfiguration(ToolBarItemGroupDescription toolBarToggelGroupDescription, ToolBarDescription toolBarDescription1, ImageIcon smallIcon) {
        return new ToolBarItemConfiguration(new ToolBarItemDescription(toolBarDescription1, toolBarToggelGroupDescription, 4), (Action)new EmptyAction(null, smallIcon));
    }

    private ToolBarItemConfiguration getToolBarItemConfiguration() {
        EmptyAction action = new EmptyAction(null, GuiIcons.INFORMATION_ICON.getSmallIcon());
        DefaultComboBoxModel<Double> comboBoxModel = new DefaultComboBoxModel<Double>(new Double[]{1.1, 1.25, 1.5, 1.75, 2.0});
        comboBoxModel.setSelectedItem(1.5);
        JComboBoxActionProvider actionContainerProvider = new JComboBoxActionProvider(comboBoxModel, (Action)action, "Test");
        JComboBox comboBox = actionContainerProvider.getContainer();
        comboBox.addActionListener(new NullActionListener());
        ToolBarDescription toolBarDescription2 = new ToolBarDescription("toolbar2", 2, false);
        ToolBarItemConfiguration toolBarItemConfiguration = new ToolBarItemConfiguration(new ToolBarItemDescription(toolBarDescription2, 4), (IActionContainerProvider)actionContainerProvider, (Action)action);
        return toolBarItemConfiguration;
    }

    public static final class EmptyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public EmptyAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static final class NullActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }
}

