/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.action.ActionCustomization;
import net.anwiba.commons.swing.action.ActionProcedurBuilder;
import net.anwiba.commons.swing.action.IActionConfiguration;
import net.anwiba.commons.swing.action.IActionCustomization;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.action.IActionTask;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.thread.cancel.ICanceler;

public class ActionConfigurationBuilder {
    private IBooleanDistributor enabledDistributor = new BooleanModel(true);
    private String tooltip = null;
    private IGuiIcon icon = null;
    private String name = null;
    private IActionProcedure procedure = null;
    private IBlock<InvocationTargetException> task;
    private IObjectModel<IGuiIcon> iconModel = new ObjectModel();
    private IObjectModel<String> toolTipModel = new ObjectModel();
    private PropertyChangeListener propertyChangeListener;
    private IConsumer<Boolean, RuntimeException> enabledConsumer;

    public ActionConfigurationBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ActionConfigurationBuilder setIcon(IGuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public ActionConfigurationBuilder setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ActionConfigurationBuilder setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        return this;
    }

    public ActionConfigurationBuilder setEnabledDistributor(IBooleanDistributor enabledModel) {
        this.enabledDistributor = enabledModel;
        return this;
    }

    public ActionConfigurationBuilder setProcedure(IActionProcedure closure) {
        if (this.procedure != null) {
            this.task = null;
        }
        this.procedure = closure;
        return this;
    }

    public <I, O> ActionConfigurationBuilder setTask(IActionTask<I, O> task) {
        if (task != null) {
            this.task = null;
        }
        this.procedure = new ActionProcedurBuilder<I, O>().setTask(task).build();
        return this;
    }

    public ActionConfigurationBuilder setTask(IBlock<InvocationTargetException> task) {
        if (task != null) {
            this.procedure = null;
        }
        this.task = task;
        return this;
    }

    public IActionConfiguration build() {
        final IBooleanDistributor enabledDistributor = this.enabledDistributor;
        final ActionCustomization customization = new ActionCustomization(this.name, this.icon, this.tooltip);
        final IActionProcedure procedure = this.createProcedure();
        if (this.iconModel.get() == null) {
            this.iconModel.set((Object)this.icon);
        }
        if (this.toolTipModel.get() == null) {
            this.toolTipModel.set((Object)this.tooltip);
        }
        return new IActionConfiguration(){

            @Override
            public IBooleanDistributor getEnabledDistributor() {
                return enabledDistributor;
            }

            @Override
            public IActionCustomization getCustomization() {
                return customization;
            }

            @Override
            public IObjectDistributor<IGuiIcon> getIconDistributor() {
                return ActionConfigurationBuilder.this.iconModel;
            }

            @Override
            public IObjectDistributor<String> getToolTipTextDistributor() {
                return ActionConfigurationBuilder.this.toolTipModel;
            }

            @Override
            public IActionProcedure getProcedure() {
                return procedure;
            }

            @Override
            public IConsumer<Boolean, RuntimeException> getEnabledConsumer() {
                return ActionConfigurationBuilder.this.enabledConsumer;
            }

            @Override
            public PropertyChangeListener getPropertyChangeListener() {
                return ActionConfigurationBuilder.this.propertyChangeListener;
            }
        };
    }

    private IActionProcedure createProcedure() {
        if (this.procedure != null) {
            return this.procedure;
        }
        if (this.task != null) {
            return new ActionProcedurBuilder().setTitle(this.name).setTask(new IActionTask<Void, Void>(){

                @Override
                public Void excecute(IMessageCollector monitor, ICanceler canceler, Void value) throws InvocationTargetException, CanceledException {
                    ActionConfigurationBuilder.this.task.execute();
                    return null;
                }
            }).build();
        }
        return new IActionProcedure(){

            @Override
            public void execute(Component value) throws RuntimeException {
            }
        };
    }

    public ActionConfigurationBuilder setIconModel(IObjectModel<IGuiIcon> iconModel) {
        this.iconModel = iconModel;
        return this;
    }

    public ActionConfigurationBuilder setToolTipModel(IObjectModel<String> toolTipModel) {
        this.toolTipModel = toolTipModel;
        return this;
    }

    public ActionConfigurationBuilder setEnabledConsumer(IConsumer<Boolean, RuntimeException> enabledConsumer) {
        this.enabledConsumer = enabledConsumer;
        return this;
    }
}

