/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IDialogConfiguration;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowPreferences;

public abstract class AbstractDialogConfiguration
implements IDialogConfiguration {
    private final IMessage message;
    private final IGuiIcon icon;
    private final Dialog.ModalityType modality;
    private final boolean isMessagePanelEnabled;
    private final DialogType dialogType;
    private final boolean isResizeable;
    private final WindowPreferences windowPreferences;
    private final String title;
    private final int dialogCloseKeyEvent;
    private final IFunction<String, String, RuntimeException> actionButtonTextFactory;
    private final List<IAdditionalActionFactory> additionalActionFactories = new ArrayList<IAdditionalActionFactory>();
    private final Dimension preferdSize;
    private final IGuiIcon image;
    private final Dialog.ModalExclusionType modalExclusionType;
    private final DataState dataState;

    public AbstractDialogConfiguration(IPreferences preferences, Dimension preferdSize, boolean isMessagePanelEnabled, String title, IMessage message, IGuiIcon icon, IGuiIcon image, Dialog.ModalityType modality, Dialog.ModalExclusionType modalExclusionType, DialogType dialogType, IFunction<String, String, RuntimeException> actionButtonTextFactory, boolean isResizeable, int dialogCloseKeyEvent, List<IAdditionalActionFactory> additionalActionFactories, DataState dataState) {
        this.preferdSize = preferdSize;
        this.title = title;
        this.image = image;
        this.modalExclusionType = modalExclusionType;
        this.actionButtonTextFactory = actionButtonTextFactory;
        this.dialogCloseKeyEvent = dialogCloseKeyEvent;
        this.dataState = dataState;
        this.additionalActionFactories.addAll(additionalActionFactories);
        this.windowPreferences = new WindowPreferences(preferences.node(new String[]{"dialog"}));
        this.message = message;
        this.icon = icon;
        this.modality = modality;
        this.dialogType = dialogType;
        this.isMessagePanelEnabled = isMessagePanelEnabled;
        this.isResizeable = isResizeable;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public final IMessage getMessage() {
        return this.message;
    }

    @Override
    public final Icon getIcon() {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getLargeIcon();
    }

    @Override
    public final boolean isMessagePanelEnabled() {
        return this.isMessagePanelEnabled;
    }

    @Override
    public Dialog.ModalExclusionType getModalExclusionType() {
        return this.modalExclusionType;
    }

    @Override
    public final Dialog.ModalityType getModalityType() {
        return this.modality;
    }

    @Override
    public final DialogType getDialogType() {
        return this.dialogType;
    }

    @Override
    public final boolean isResizeable() {
        return this.isResizeable;
    }

    @Override
    public Dimension getPreferdSize() {
        return this.preferdSize;
    }

    @Override
    public IWindowPreferences getWindowPreferences() {
        return this.windowPreferences;
    }

    @Override
    public final int getDialogCloseKeyEvent() {
        return this.dialogCloseKeyEvent;
    }

    @Override
    public List<IAdditionalActionFactory> getAdditionalActionFactories() {
        return this.additionalActionFactories;
    }

    @Override
    public final IFunction<String, String, RuntimeException> getActionButtonTextFactory() {
        return this.actionButtonTextFactory;
    }

    @Override
    public Image getImage() {
        return this.image == null ? null : this.image.getSmallIcon().getImage();
    }

    @Override
    public DataState getDataState() {
        return this.dataState;
    }
}

