/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.ContentPaneBuilder;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogConfiguration;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IContentPaneFactory;
import net.anwiba.commons.swing.dialog.IDialogConfiguration;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.icon.IGuiIcon;

public class DialogConfigurationBuilder {
    private final List<IAdditionalActionFactory> additionalActionFactories = new ArrayList<IAdditionalActionFactory>();
    private IFunction<String, String, RuntimeException> actionButtonTextFactory = s -> s;
    private IPreferences preferences = new DummyPreferences(new String[0]);
    private DialogType dialogType = DialogType.NONE;
    private IContentPaneFactory contentPaneFactory = (owner, preferences, dataStateModel) -> new AbstractContentPane(dataStateModel){

        @Override
        public JComponent getComponent() {
            JPanel panel = new JPanel();
            if (!DialogConfigurationBuilder.this.isMessagePanelEnabled) {
                panel.setMinimumSize(new Dimension(200, 100));
                panel.setPreferredSize(new Dimension(200, 100));
            }
            return panel;
        }
    };
    private String title = DialogMessages.Dialog;
    private IMessage message = null;
    private IGuiIcon icon = null;
    private Dialog.ModalityType modality = Dialog.DEFAULT_MODALITY_TYPE;
    private Dialog.ModalExclusionType modalExclusionType;
    private boolean isMessagePanelEnabled = false;
    private boolean isResizeable = true;
    private int dialogCloseKeyEvent = 0;
    private Dimension preferdSize;
    private IGuiIcon image;
    private DataState dataState = DataState.UNKNOWN;

    public DialogConfigurationBuilder setMessage(IMessage message) {
        this.message = message;
        return this;
    }

    public DialogConfigurationBuilder setActionButtonTextFactory(IFunction<String, String, RuntimeException> actionButtonTextFactory) {
        this.actionButtonTextFactory = actionButtonTextFactory;
        return this;
    }

    public DialogConfigurationBuilder setContentPaneFactory(IContentPaneFactory contentPaneFactory) {
        this.contentPaneFactory = contentPaneFactory;
        return this;
    }

    public DialogConfigurationBuilder setResizeable(boolean isResizeable) {
        this.isResizeable = isResizeable;
        return this;
    }

    public DialogConfigurationBuilder setIcon(IGuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public DialogConfigurationBuilder setDialogIcon(IGuiIcon image) {
        this.image = image;
        return this;
    }

    public DialogConfigurationBuilder setMessagePanelEnabled(boolean isMessagePanelEnabled) {
        this.isMessagePanelEnabled = isMessagePanelEnabled;
        return this;
    }

    public DialogConfigurationBuilder setModality(Dialog.ModalityType modality) {
        this.modality = modality;
        return this;
    }

    public DialogConfigurationBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public DialogConfigurationBuilder setDialogType(DialogType dialogType) {
        this.dialogType = dialogType;
        return this;
    }

    public DialogConfigurationBuilder setPreferences(IPreferences preferences) {
        this.preferences = preferences;
        return this;
    }

    public IDialogConfiguration build() {
        ContentPaneBuilder contentPaneBuilder = new ContentPaneBuilder(this.contentPaneFactory);
        contentPaneBuilder.setPreferences(this.preferences);
        return new DialogConfiguration(this.preferences, this.preferdSize, this.isMessagePanelEnabled, this.title, this.message, this.icon, this.image, this.modality, this.modalExclusionType, this.dialogType, this.actionButtonTextFactory, this.isResizeable, this.dialogCloseKeyEvent, this.additionalActionFactories, this.dataState, contentPaneBuilder);
    }

    public DialogConfigurationBuilder setDialogCloseKeyEvent(int dialogCloseKeyEvent) {
        this.dialogCloseKeyEvent = dialogCloseKeyEvent;
        return this;
    }

    public DialogConfigurationBuilder addAdditionalAction(IAdditionalActionFactory factory) {
        this.additionalActionFactories.add(factory);
        return this;
    }

    public DialogConfigurationBuilder setPreferdSize(Dimension preferdSize) {
        this.preferdSize = preferdSize;
        return this;
    }

    public DialogConfigurationBuilder setModalExclusionType(Dialog.ModalExclusionType modalExclusionType) {
        this.modalExclusionType = modalExclusionType;
        return this;
    }

    public DialogConfigurationBuilder setCloseButtonDialog() {
        this.setDialogType(DialogType.CLOSE);
        return this;
    }

    public DialogConfigurationBuilder setCancleOkButtonDialog() {
        this.setDialogType(DialogType.CANCEL_OK);
        return this;
    }

    public DialogConfigurationBuilder enableCloseOnEscape() {
        this.setDialogCloseKeyEvent(27);
        return this;
    }

    public DialogConfigurationBuilder setDataState(DataState dataState) {
        this.dataState = dataState;
        return this;
    }
}

