/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.dialog.exception.ExceptionDialog;
import net.anwiba.commons.swing.icon.GuiIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class MessageDialogLauncher {
    private final MessageBuilder builder = new MessageBuilder();
    private String title = "Title";
    GuiIcon icon = GuiIcons.EMPTY_ICON;
    DialogType dialogType = DialogType.CLOSE;
    private int dialogCloseKeyEvent = 27;

    public MessageDialogLauncher enableCloseOnEscape() {
        this.dialogCloseKeyEvent = 27;
        return this;
    }

    public MessageDialogLauncher disableCloseOnEscape() {
        this.dialogCloseKeyEvent = 0;
        return this;
    }

    public MessageDialogLauncher icon(GuiIcon icon) {
        this.icon = icon;
        return this;
    }

    public MessageDialogLauncher closeButtonDialog() {
        this.dialogType = DialogType.CLOSE;
        return this;
    }

    public MessageDialogLauncher cancleOkButtonDialog() {
        this.dialogType = DialogType.CANCEL_OK;
        return this;
    }

    public MessageDialogLauncher dialogType(DialogType dialogType) {
        this.dialogType = dialogType;
        return this;
    }

    public MessageDialogLauncher title(String title) {
        this.title = title;
        return this;
    }

    public MessageDialogLauncher text(String text) {
        this.builder.setText(text);
        return this;
    }

    public MessageDialogLauncher description(String description) {
        this.builder.setDescription(description);
        return this;
    }

    public MessageDialogLauncher throwable(Throwable throwable) {
        this.builder.setThrowable(throwable);
        return this;
    }

    public MessageDialogLauncher type(MessageType messageType) {
        this.builder.setType(messageType);
        return this;
    }

    public MessageDialogLauncher error() {
        this.builder.setError();
        return this;
    }

    public MessageDialogLauncher info() {
        this.builder.setInfo();
        return this;
    }

    public MessageDialogLauncher warning() {
        this.builder.setWarning();
        return this;
    }

    public MessageDialogLauncher message(IMessage message) {
        this.builder.setMessage(message);
        return this;
    }

    public IDialogResult launch(Component component) {
        return this.launch(component == null ? (Window)null : SwingUtilities.windowForComponent(component));
    }

    public IDialogResult launch(Window owner) {
        ObjectModel model = new ObjectModel();
        IMessage message = this.builder.build();
        GuiUtilities.invokeAndWait(() -> this.lambda$launch$0(owner, message, (IObjectModel)model));
        return (IDialogResult)model.get();
    }

    private static MessageDialog create(Window owner, String title, IMessage message, Icon icon, DialogType dialogType) {
        if (message instanceof ExceptionMessage) {
            return new ExceptionDialog(owner, (ExceptionMessage)message);
        }
        return new MessageDialog(owner, title, message, icon, dialogType);
    }

    private /* synthetic */ void lambda$launch$0(Window owner, IMessage message, IObjectModel model) {
        final MessageDialog dialog = MessageDialogLauncher.create(owner, this.title, message, this.icon.getLargeIcon(), this.dialogType);
        if (this.dialogCloseKeyEvent != 0) {
            KeyStroke stroke = KeyStroke.getKeyStroke(this.dialogCloseKeyEvent, 0);
            JRootPane pane = dialog.getRootPane();
            pane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    dialog.setVisible(false);
                }
            }, stroke, 2);
        }
        dialog.setVisible(true);
        model.set((Object)dialog.getResult());
    }
}

