/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.pane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.date.MonthView;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.IntegerFieldBuilder;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;

public final class LocalDateTimeContentPane
extends AbstractContentPane {
    private JComponent contentPanel;
    private final IObjectModel<LocalDateTime> dateTimeModel;
    final IObjectModel<LocalDateTime> model;

    public LocalDateTimeContentPane(IObjectModel<DataState> dataStateModel, IObjectModel<LocalDateTime> model) {
        super(dataStateModel);
        this.dateTimeModel = model;
        this.model = new ObjectModel((Object)((LocalDateTime)Optional.of((Object)((LocalDateTime)this.dateTimeModel.get())).getOr(() -> {
            this.getDataStateModel().set((Object)DataState.MODIFIED);
            LocalDateTime now = UserDateTimeUtilities.now();
            return LocalDateTime.of(now.getYear(), now.getMonth(), now.getDayOfMonth(), now.getHour(), now.getMinute(), 0, 0);
        })));
    }

    @Override
    public JComponent getComponent() {
        if (this.contentPanel != null) {
            return this.contentPanel;
        }
        ObjectModel hourModel = new ObjectModel((Object)((Integer)Optional.of((Object)((LocalDateTime)this.model.get())).convert(d -> d.getHour()).get()));
        ObjectModel minuteModel = new ObjectModel((Object)((Integer)Optional.of((Object)((LocalDateTime)this.model.get())).convert(d -> d.getMinute()).get()));
        ObjectModel dateModel = new ObjectModel((Object)((LocalDate)Optional.of((Object)((LocalDateTime)this.model.get())).convert(d -> LocalDate.of(d.getYear(), d.getMonthValue(), d.getDayOfMonth())).get()));
        hourModel.addChangeListener(() -> this.lambda$getComponent$4((IObjectModel)hourModel));
        minuteModel.addChangeListener(() -> this.lambda$getComponent$5((IObjectModel)minuteModel));
        dateModel.addChangeListener(() -> this.lambda$getComponent$7((IObjectModel)dateModel));
        IObjectField hourField = ((IntegerFieldBuilder)((IntegerFieldBuilder)((IntegerFieldBuilder)new IntegerFieldBuilder().setColumns(4)).setModel(hourModel)).setToolTip("Hour")).addModuloSpinnerActions(24, 1).build();
        IObjectField minuteField = ((IntegerFieldBuilder)((IntegerFieldBuilder)((IntegerFieldBuilder)new IntegerFieldBuilder().setColumns(4)).setModel(minuteModel)).setToolTip("Minute")).addModuloSpinnerActions(60, 1).build();
        MonthView monthView = new MonthView((IObjectModel<LocalDate>)dateModel);
        IChangeableObjectListener validatorsListener = new IChangeableObjectListener((IObjectModel)dateModel, hourField, minuteField){
            final /* synthetic */ IObjectModel val$dateModel;
            final /* synthetic */ IObjectField val$hourField;
            final /* synthetic */ IObjectField val$minuteField;
            {
                this.val$dateModel = iObjectModel;
                this.val$hourField = iObjectField;
                this.val$minuteField = iObjectField2;
            }

            public void objectChanged() {
                if (this.val$dateModel.get() == null) {
                    this.set("Date", "missing selected value");
                    return;
                }
                IValidationResult result = (IValidationResult)this.val$hourField.getValidationResultDistributor().get();
                if (!result.isValid()) {
                    this.set("Hour", result.getMessage());
                    return;
                }
                result = (IValidationResult)this.val$minuteField.getValidationResultDistributor().get();
                if (!result.isValid()) {
                    this.set("Minute", result.getMessage());
                    return;
                }
                LocalDateTimeContentPane.this.getMessageModel().set(null);
                LocalDateTimeContentPane.this.getDataStateModel().set((Object)DataState.MODIFIED);
            }

            private void set(String string, String message) {
                LocalDateTimeContentPane.this.getMessageModel().set((Object)new MessageBuilder().setText(string + ", " + message).setError().build());
                LocalDateTimeContentPane.this.getDataStateModel().set((Object)DataState.INVALIDE);
            }
        };
        hourField.getValidationResultDistributor().addChangeListener(validatorsListener);
        minuteField.getValidationResultDistributor().addChangeListener(validatorsListener);
        dateModel.addChangeListener(validatorsListener);
        JPanel timePanel = new JPanel();
        timePanel.add(hourField.getComponent());
        timePanel.add(minuteField.getComponent());
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new BoxLayout(headPanel, 1));
        headPanel.add(monthView);
        headPanel.add(timePanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)headPanel, "North");
        this.contentPanel = new JScrollPane(panel);
        return this.contentPanel;
    }

    private LocalDateTime adapt(LocalDateTime dateTime, LocalDate date) {
        return dateTime.withYear(date.getYear()).withMonth(date.getMonthValue()).withDayOfMonth(date.getDayOfMonth());
    }

    @Override
    public boolean apply() {
        this.dateTimeModel.set((Object)((LocalDateTime)this.model.get()));
        return true;
    }

    private /* synthetic */ void lambda$getComponent$7(IObjectModel dateModel) {
        Optional.of((Object)((LocalDate)dateModel.get())).consume(d -> this.model.set((Object)this.adapt((LocalDateTime)this.model.get(), (LocalDate)d)));
    }

    private /* synthetic */ void lambda$getComponent$5(IObjectModel minuteModel) {
        this.model.set((Object)((LocalDateTime)this.model.get()).withMinute((Integer)minuteModel.get()));
    }

    private /* synthetic */ void lambda$getComponent$4(IObjectModel hourModel) {
        this.model.set((Object)((LocalDateTime)this.model.get()).withHour((Integer)hourModel.get()));
    }
}

