/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.pane;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.StringField;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;

public final class StringFieldContentPane
extends AbstractContentPane {
    final StringField stringField;
    private JComponent contentPanel;
    private final String label;

    public StringFieldContentPane(IObjectModel<DataState> dataStateModel, String label, IObjectFieldConfiguration<String> configuration) {
        super(dataStateModel);
        this.label = label;
        this.stringField = new StringField(configuration);
        this.stringField.getModel().addChangeListener(() -> {
            IValidationResult validationResult = (IValidationResult)this.stringField.getValidationResultDistributor().get();
            if (validationResult.isValid()) {
                this.getDataStateModel().set((Object)DataState.VALIDE);
                this.getMessageModel().set(null);
                return;
            }
            this.getDataStateModel().set((Object)DataState.INVALIDE);
            this.getMessageModel().set((Object)Message.create((String)validationResult.getMessage(), (String)validationResult.getMessage(), (MessageType)MessageType.ERROR));
        });
    }

    public IObjectModel<String> getModel() {
        return this.stringField.getModel();
    }

    @Override
    public JComponent getComponent() {
        if (this.contentPanel != null) {
            return this.contentPanel;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new SpringLayout());
        if (this.label == null) {
            panel.add(this.stringField.getComponent());
            SpringLayoutUtilities.makeCompactGrid(panel, 1, 1, 6, 6, 6, 6);
            this.contentPanel = new JScrollPane(panel);
            return this.contentPanel;
        }
        panel.add(new JLabel(this.label));
        panel.add(this.stringField.getComponent());
        SpringLayoutUtilities.makeCompactGrid(panel, 2, 1, 6, 6, 6, 6);
        this.contentPanel = new JScrollPane(panel);
        return this.contentPanel;
    }

    @Override
    public IObjectModel<DataState> getDataStateModel() {
        return super.getDataStateModel();
    }
}

