/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.progress;

import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.swing.dialog.progress.ProgressDialog;
import net.anwiba.commons.thread.progress.IProgressTask;

public class ProgressDialogLauncher<O, E extends Exception> {
    private final MessageBuilder builder = new MessageBuilder();
    private final IProgressTask<O, E> task;
    private String titel = null;

    public ProgressDialogLauncher(IProgressTask<O, E> task) {
        this.task = task;
    }

    public ProgressDialogLauncher<O, E> setTitle(String titel) {
        this.titel = titel;
        return this;
    }

    public ProgressDialogLauncher<O, E> setText(String text) {
        this.builder.setText(text);
        return this;
    }

    public ProgressDialogLauncher<O, E> setDescription(String description) {
        this.builder.setDescription(description);
        return this;
    }

    public O launch(Window owner) throws E, CanceledException {
        IMessage message = this.builder.build();
        return ProgressDialog.show(owner, this.titel == null ? message.getText() : this.titel, message, this.task);
    }

    public O launch(Component component) throws E, CanceledException {
        return this.launch(component == null ? (Window)null : SwingUtilities.windowForComponent(component));
    }
}

