/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.list.IListModel;
import net.anwiba.commons.swing.list.IObjectListConfiguration;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.list.ObjectUiCellRendererConfigurationBuilder;
import net.anwiba.commons.swing.ui.ObjectUiListCellRenderer;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class ObjectListComponent<T>
implements IComponentProvider {
    private static ILogger logger = Logging.getLogger(ObjectListComponent.class);
    private final JComponent component;
    private final ISelectionModel<T> selectionModel;
    private JList<T> list;
    private IObjectListConfiguration<T> configuration;

    public ObjectListComponent(IListModel<T> listModel) {
        this(new ObjectListConfigurationBuilder().build(), listModel);
    }

    public ObjectListComponent(IObjectListConfiguration<T> configuration, IListModel<T> listModel) {
        this.configuration = configuration;
        this.list = new JList<T>(listModel);
        this.list.setVisibleRowCount(configuration.getVisibleRowCount());
        this.list.setSelectionMode(configuration.getSelectionMode());
        this.list.setLayoutOrientation(configuration.getLayoutOrientation());
        this.list.setCellRenderer(new ObjectUiListCellRenderer<T>(configuration.getObjectUiCellRendererConfiguration(), configuration.getObjectUi()));
        ListSelectionModel tableSelectionModel = this.list.getSelectionModel();
        this.selectionModel = configuration.getSelectionModel();
        tableSelectionModel.addListSelectionListener(new JListSelectionListener<T>(listModel, tableSelectionModel, this.selectionModel));
        this.selectionModel.addSelectionListener(new SelectionListener<T>(listModel, tableSelectionModel, this.selectionModel));
        this.list.setTransferHandler(configuration.getTransferHandler());
        this.list.setDropMode(configuration.getDropMode());
        this.list.setDragEnabled(configuration.isDragEnabled());
        Optional.ofNullable(configuration.getMouseListener()).ifPresent(l -> this.list.addMouseListener((MouseListener)l));
        this.component = new JScrollPane(this.list);
    }

    public void scrollToSelectedObject() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex != -1) {
            GuiUtilities.invokeLater(() -> this.list.ensureIndexIsVisible(selectedIndex));
        }
    }

    public void setVerticalLayout() {
        GuiUtilities.invokeLater(() -> {
            this.list.setCellRenderer(new ObjectUiListCellRenderer<T>(new ObjectUiCellRendererConfigurationBuilder().build(), this.configuration.getObjectUi()));
            this.list.setLayoutOrientation(0);
        });
    }

    public void setHorizontalWrapLayout() {
        GuiUtilities.invokeLater(() -> {
            this.list.setCellRenderer(new ObjectUiListCellRenderer<T>(this.configuration.getObjectUiCellRendererConfiguration(), this.configuration.getObjectUi()));
            this.list.setLayoutOrientation(2);
        });
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public ISelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public static final class SelectionListener<T>
    implements ISelectionListener<T> {
        private final IListModel<T> listModel;
        private final ListSelectionModel tableSelectionModel;
        private final ISelectionModel<T> objectSelectionModel;

        public SelectionListener(IListModel<T> listModel, ListSelectionModel tableSelectionModel, ISelectionModel<T> objectSelectionModel) {
            this.listModel = listModel;
            this.tableSelectionModel = tableSelectionModel;
            this.objectSelectionModel = objectSelectionModel;
        }

        public void selectionChanged(SelectionEvent<T> event) {
            if (this.objectSelectionModel.isEmpty() && this.tableSelectionModel.isSelectionEmpty()) {
                return;
            }
            if (this.objectSelectionModel.isEmpty()) {
                this.tableSelectionModel.clearSelection();
                return;
            }
            List<T> objects = this.getObjects(this.listModel, this.tableSelectionModel);
            List selectedObjects = IterableUtilities.asList((Iterable)this.objectSelectionModel.getSelectedObjects());
            if (objects.size() == this.objectSelectionModel.size() && objects.containsAll(selectedObjects)) {
                return;
            }
            GuiUtilities.invokeLater(() -> {
                int[] indexes;
                this.tableSelectionModel.setValueIsAdjusting(true);
                this.tableSelectionModel.clearSelection();
                for (int index : indexes = this.listModel.getIndicesOf(selectedObjects)) {
                    try {
                        this.tableSelectionModel.addSelectionInterval(index, index);
                    }
                    catch (NullPointerException exception) {
                        logger.log(ILevel.ERROR, exception.getMessage(), (Throwable)exception);
                    }
                }
                this.tableSelectionModel.setValueIsAdjusting(false);
            });
        }

        private List<T> getObjects(IListModel<T> tableModel, ListSelectionModel tableSelectionModel) {
            ArrayList<T> objects = new ArrayList<T>();
            if (tableSelectionModel.isSelectionEmpty()) {
                return objects;
            }
            for (int i = tableSelectionModel.getMinSelectionIndex(); i <= tableSelectionModel.getMaxSelectionIndex(); ++i) {
                if (!tableSelectionModel.isSelectedIndex(i)) continue;
                objects.add(tableModel.getObject(i));
            }
            return objects;
        }
    }

    public static final class JListSelectionListener<T>
    implements ListSelectionListener {
        private final IListModel<T> listModel;
        private final ListSelectionModel listSelectionModel;
        private final ISelectionModel<T> objectSelectionModel;

        public JListSelectionListener(IListModel<T> listModel, ListSelectionModel listSelectionModel, ISelectionModel<T> objectSelectionModel) {
            this.listModel = listModel;
            this.listSelectionModel = listSelectionModel;
            this.objectSelectionModel = objectSelectionModel;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (this.listSelectionModel.isSelectionEmpty()) {
                this.objectSelectionModel.removeAllSelectedObjects();
                return;
            }
            ArrayList<T> objects = new ArrayList<T>();
            for (int i = this.listSelectionModel.getMinSelectionIndex(); i <= this.listSelectionModel.getMaxSelectionIndex(); ++i) {
                if (!this.listSelectionModel.isSelectedIndex(i)) continue;
                objects.add(this.listModel.getObject(i));
            }
            this.objectSelectionModel.setSelectedObjects(objects);
        }
    }
}

