/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.list;

import java.awt.event.MouseListener;
import javax.swing.DropMode;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.swing.list.IObjectListConfiguration;
import net.anwiba.commons.swing.list.ObjectUiCellRendererConfigurationBuilder;
import net.anwiba.commons.swing.ui.IObjectUi;
import net.anwiba.commons.swing.ui.IObjectUiCellRendererConfiguration;
import net.anwiba.commons.swing.ui.ToStringUi;

public class ObjectListConfigurationBuilder<T> {
    private int visibleRowCount = 8;
    private int selectionMode = 2;
    private IObjectUi<T> objectUi = new ToStringUi();
    private int layoutOrientation = 0;
    private MouseListener mouseListener;
    private ISelectionModel<T> selectionModel;
    private TransferHandler transferHandler;
    private boolean isDragEnabled = false;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private T prototype = null;
    private final ObjectUiCellRendererConfigurationBuilder objectUiCellRendererConfigurationBuilder = new ObjectUiCellRendererConfigurationBuilder();

    public ObjectListConfigurationBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.objectUi = objectUi;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSingleSelectionMode() {
        this.selectionMode = 0;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSingleIntervalSelectionMode() {
        this.selectionMode = 1;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setMultiSelectionMode() {
        this.selectionMode = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setIconTextGap(int iconTextGap) {
        this.objectUiCellRendererConfigurationBuilder.setIconTextGap(iconTextGap);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalTextPosition(int verticalTextPosition) {
        this.objectUiCellRendererConfigurationBuilder.setVerticalTextPosition(verticalTextPosition);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalTextPosition(int horizontalTextPosition) {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalTextPosition(horizontalTextPosition);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignment(int horizontalAlignment) {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentLeft() {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignmentLeft();
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentRight() {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignmentRight();
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentCenter() {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignmentCenter();
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentLeading() {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignmentLeading();
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalAlignmentTrailing() {
        this.objectUiCellRendererConfigurationBuilder.setHorizontalAlignmentTrailing();
        return this;
    }

    public ObjectListConfigurationBuilder<T> setBorder(Border border) {
        this.objectUiCellRendererConfigurationBuilder.setBorder(border);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalAlignment(int verticalAlignment) {
        this.objectUiCellRendererConfigurationBuilder.setVerticalAlignment(verticalAlignment);
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalOrientation() {
        this.layoutOrientation = 0;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setVerticalWrapOrientation() {
        this.layoutOrientation = 1;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setHorizontalWrapOrientation() {
        this.layoutOrientation = 2;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setTransferHandler(TransferHandler transferHandler) {
        this.transferHandler = transferHandler;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setSelectionModel(ISelectionModel<T> selectionModel) {
        this.selectionModel = selectionModel;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDragDisabled() {
        this.isDragEnabled = false;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDragEnabled() {
        this.isDragEnabled = true;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropInsertEnabled() {
        this.dropMode = DropMode.INSERT;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropReplaceEnabled() {
        this.dropMode = DropMode.ON;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropReplaceOrInsertEnabled() {
        this.dropMode = DropMode.ON_OR_INSERT;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setDropToSelectedEnabled() {
        this.dropMode = DropMode.USE_SELECTION;
        return this;
    }

    public ObjectListConfigurationBuilder<T> setPrototype(T prototype) {
        this.prototype = prototype;
        return this;
    }

    public IObjectListConfiguration<T> build() {
        final IObjectUiCellRendererConfiguration objectUiCellRendererConfiguration = this.objectUiCellRendererConfigurationBuilder.build();
        return new IObjectListConfiguration<T>(){

            @Override
            public int getLayoutOrientation() {
                return ObjectListConfigurationBuilder.this.layoutOrientation;
            }

            @Override
            public MouseListener getMouseListener() {
                return ObjectListConfigurationBuilder.this.mouseListener;
            }

            @Override
            public int getVisibleRowCount() {
                return ObjectListConfigurationBuilder.this.visibleRowCount;
            }

            @Override
            public IObjectUi<T> getObjectUi() {
                return ObjectListConfigurationBuilder.this.objectUi;
            }

            @Override
            public int getSelectionMode() {
                return ObjectListConfigurationBuilder.this.selectionMode;
            }

            @Override
            public IObjectUiCellRendererConfiguration getObjectUiCellRendererConfiguration() {
                return objectUiCellRendererConfiguration;
            }

            @Override
            public ISelectionModel<T> getSelectionModel() {
                return ObjectListConfigurationBuilder.this.selectionModel == null ? new ISelectionModel() : ObjectListConfigurationBuilder.this.selectionModel;
            }

            @Override
            public TransferHandler getTransferHandler() {
                return ObjectListConfigurationBuilder.this.transferHandler;
            }

            @Override
            public DropMode getDropMode() {
                return ObjectListConfigurationBuilder.this.dropMode;
            }

            @Override
            public boolean isDragEnabled() {
                return ObjectListConfigurationBuilder.this.isDragEnabled;
            }

            @Override
            public T getPrototype() {
                return ObjectListConfigurationBuilder.this.prototype;
            }
        };
    }
}

