/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.swing.object.AbstractObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class IntegerObjectFieldConfigurationBuilder
extends AbstractObjectFieldConfigurationBuilder<Integer, IntegerObjectFieldConfigurationBuilder> {
    public IntegerObjectFieldConfigurationBuilder() {
        super(new IValidator<String>(){

            public IValidationResult validate(String value) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                    return IValidationResult.valid();
                }
                try {
                    Integer.valueOf(value);
                    return IValidationResult.valid();
                }
                catch (Throwable exception) {
                    return IValidationResult.inValid((String)exception.getLocalizedMessage());
                }
            }
        }, new IConverter<String, Integer, RuntimeException>(){

            public Integer convert(String number) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)number)) {
                    return null;
                }
                return Integer.valueOf(number);
            }
        }, new IConverter<Integer, String, RuntimeException>(){

            public String convert(Integer number) {
                if (number == null) {
                    return null;
                }
                return number.toString();
            }
        });
        this.setCharacterFilter(c -> Character.isDigit(c) || c == '+' || c == '-');
    }
}

