/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.LocalDateTimeField;
import net.anwiba.commons.swing.object.LocalDateTimeObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class LocalDateTimeFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<LocalDateTime, LocalDateTimeObjectFieldConfigurationBuilder, LocalDateTimeFieldBuilder> {
    public LocalDateTimeFieldBuilder() {
        super(new LocalDateTimeObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<LocalDateTime> create(IObjectFieldConfiguration<LocalDateTime> configuration) {
        return new LocalDateTimeField(configuration);
    }

    public LocalDateTimeFieldBuilder addSliderActions(LocalDateTime minimum, LocalDateTime maximum, long step, TemporalUnit unit) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (LocalDateTime)converter.convert(v1)).convert(v2 -> this.isValid((LocalDateTime)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<LocalDateTime, LocalDateTime> add = input -> (LocalDateTime)Optional.of((Object)input).convert(v1 -> v1.plus(step, unit)).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> minimum);
        Function<LocalDateTime, LocalDateTime> minus = input -> (LocalDateTime)Optional.of((Object)input).convert(v1 -> v1.minus(step, unit)).convert(v2 -> v2.compareTo(minimum) < 0 ? minimum : v2).convert(v3 -> v3.compareTo(maximum) > 0 ? maximum : v3).getOr(() -> maximum);
        Function<LocalDateTime, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(minimum) > 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, 250, 100));
        Function<LocalDateTime, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4.compareTo(maximum) < 0 && minimum.compareTo(maximum) < 0).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, 250, 100));
        return this;
    }

    public IValidationResult isValid(LocalDateTime value, LocalDateTime minimum, LocalDateTime maximum) {
        return value.compareTo(minimum) < 0 ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value.compareTo(maximum) > 0 ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

