/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.preference;

import java.awt.Color;
import java.text.MessageFormat;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.preference.ColorPreference;

public class ColorListPreference {
    private static final String NUMBER_OF_COLORS = "numberOfColors";
    private final IPreferences preferences;

    public ColorListPreference(IPreferences preferences) {
        this.preferences = preferences;
    }

    public Color[] getColors() {
        int numberOfColors = this.preferences.getInt(NUMBER_OF_COLORS, 0);
        Color[] colors = new Color[numberOfColors];
        for (int i = 0; i < numberOfColors; ++i) {
            ColorPreference preference = this.getColorPreferences(i);
            colors[i] = preference.getColor();
        }
        return colors;
    }

    public void setColors(Color[] colors) {
        int numberOfColors = colors.length;
        for (int i = 0; i < numberOfColors; ++i) {
            ColorPreference preference = this.getColorPreferences(i);
            preference.setColor(colors[i]);
        }
        this.preferences.setInt(NUMBER_OF_COLORS, numberOfColors);
        this.preferences.flush();
    }

    public ColorPreference getColorPreferences(int i) {
        return new ColorPreference(this.preferences.node(new String[]{MessageFormat.format("color{0,number,000}", i)}));
    }
}

