/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.action;

import javax.swing.Action;
import net.anwiba.commons.lang.primitive.IBooleanProvider;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.swing.table.IObjectTableModel;
import net.anwiba.commons.swing.table.ISelectionIndexModel;
import net.anwiba.commons.swing.table.action.ITableActionFactory;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public abstract class AbstractTableActionFactory<T>
implements ITableActionFactory<T> {
    @Override
    public Action create(final IObjectTableModel<T> tableModel, final ISelectionIndexModel<T> selectionIndexModel, final ISelectionModel<T> selectionModel, final IBooleanDistributor sortStateModel) {
        final Action action = this.createAction(tableModel, selectionIndexModel, selectionModel, sortStateModel);
        action.setEnabled(this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel));
        tableModel.addListModelListener(new IChangeableListListener<T>(){

            public void objectsAdded(Iterable<Integer> indeces, Iterable<T> object) {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<T> object) {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<T> oldObjects, Iterable<T> newObjects) {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }

            public void objectsChanged(Iterable<T> oldObjects, Iterable<T> newObjects) {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }
        });
        selectionIndexModel.addSelectionListener(new ISelectionListener<T>(){

            public void selectionChanged(SelectionEvent<T> event) {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }
        });
        sortStateModel.addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                GuiUtilities.invokeLater(() -> action.setEnabled(AbstractTableActionFactory.this.checkEnabled(tableModel, selectionIndexModel, selectionModel, (IBooleanProvider)sortStateModel)));
            }
        });
        return action;
    }

    protected abstract boolean checkEnabled(IObjectTableModel<T> var1, ISelectionIndexModel<T> var2, ISelectionModel<T> var3, IBooleanProvider var4);

    protected abstract Action createAction(IObjectTableModel<T> var1, ISelectionIndexModel<T> var2, ISelectionModel<T> var3, IBooleanDistributor var4);
}

