/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.filter;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.TableModel;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.IRowMapper;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.filter.Mapper;

public class ContainsFilter
implements IRowFilter {
    private final String[] strings;
    private final IColumToStringConverter converter;
    private final int[] columnIndexes;

    public ContainsFilter(String string, IColumToStringConverter converter) {
        this.strings = string.split(" ");
        this.converter = converter;
        this.columnIndexes = converter.getFilterableColumnIndicies();
    }

    @Override
    public IRowMapper filter(TableModel tableModel) {
        ArrayList<Integer> mapping = new ArrayList<Integer>();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            boolean[] flags = new boolean[this.strings.length];
            Arrays.fill(flags, false);
            for (int j = 0; j < this.columnIndexes.length; ++j) {
                this.validate(flags, this.converter.convert(j, tableModel.getValueAt(i, this.columnIndexes[j])));
            }
            if (!this.isTrue(flags)) continue;
            mapping.add(i);
        }
        return new Mapper(mapping);
    }

    private boolean isTrue(boolean[] flags) {
        boolean flag = true;
        for (boolean value : flags) {
            flag = flag && value;
        }
        return flag;
    }

    private void validate(boolean[] flags, String value) {
        if (value == null) {
            return;
        }
        for (int i = 0; i < this.strings.length; ++i) {
            flags[i] = flags[i] || value.toLowerCase().contains(this.strings[i].toLowerCase());
        }
    }
}

