/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table.filter;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.anwiba.commons.swing.table.IRowMapper;

public class Mapper
implements IRowMapper {
    private final List<Integer> mapping;

    public Mapper(List<Integer> mapping) {
        this.mapping = mapping;
    }

    @Override
    public int getRowCount() {
        return this.mapping.size();
    }

    @Override
    public int getRowIndex(int rowIndex) {
        if (rowIndex > -1 && rowIndex < this.mapping.size()) {
            return this.mapping.get(rowIndex);
        }
        return -1;
    }

    @Override
    public int getMappedRowIndex(int rowIndex) {
        for (int i = 0; i < this.mapping.size(); ++i) {
            if (this.mapping.get(i) != rowIndex) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterable<Integer> indeces() {
        return Collections.unmodifiableList(this.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.mapping);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mapper other = (Mapper)obj;
        return Objects.equals(this.mapping, other.mapping);
    }
}

