/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.toolbar;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JToolBar;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.action.IActionContainerProvider;
import net.anwiba.commons.swing.toolbar.ToolBarDescription;
import net.anwiba.commons.swing.toolbar.ToolBarItemConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupConfiguration;
import net.anwiba.commons.swing.toolbar.ToolBarItemGroupDescription;
import net.anwiba.commons.utilities.registry.KeyValueRegistry;

public class ToolBarConfiguration {
    private final ToolBarDescription description;
    private final KeyValueRegistry<ToolBarItemGroupDescription, ToolBarItemGroupConfiguration> registry = new KeyValueRegistry();
    final Comparator<ToolBarItemGroupDescription> comparator = new ToolBarItemGroupDescriptionComparator();

    public ToolBarConfiguration(ToolBarDescription description) {
        this.description = description;
    }

    public ToolBarDescription getDescription() {
        return this.description;
    }

    public ToolBarItemGroupConfiguration get(ToolBarItemGroupDescription toolBarGroupDescription) {
        return (ToolBarItemGroupConfiguration)this.registry.get((Object)toolBarGroupDescription);
    }

    public void add(ToolBarItemGroupConfiguration toolBarGroup) {
        this.registry.register((Object)toolBarGroup.getDescription(), (Object)toolBarGroup);
    }

    public void remove(ToolBarItemGroupConfiguration toolBarGroup) {
        this.registry.remove((Object)toolBarGroup.getDescription());
    }

    public JToolBar getJToolBar() {
        ToolBarItemGroupConfiguration[] toolBarGroups = (ToolBarItemGroupConfiguration[])this.registry.getItems(this.comparator, ToolBarItemGroupDescription.class, ToolBarItemGroupConfiguration.class);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(this.isFloatable());
        for (int i = 0; i < toolBarGroups.length; ++i) {
            if (i > 0) {
                toolBar.addSeparator(new Dimension(3, 1));
            }
            ToolBarItemConfiguration[] toolBarItemConfigurations = toolBarGroups[i].getToolBarItemConfigurations();
            if (toolBarGroups[i].getDescription().isToggelGroup()) {
                ArrayList<Action> actions = new ArrayList<Action>();
                ActionDisabler listener = new ActionDisabler(actions);
                for (ToolBarItemConfiguration toolBarItemConfiguration : toolBarItemConfigurations) {
                    Optional.of((Object)this.addToToolBar(toolBar, toolBarItemConfiguration)).consume(button -> button.addActionListener(listener));
                    Optional.of((Object)toolBarItemConfiguration.getAction()).consume(a -> actions.add((Action)a));
                }
                continue;
            }
            for (ToolBarItemConfiguration toolBarItemConfiguration : toolBarItemConfigurations) {
                this.addToToolBar(toolBar, toolBarItemConfiguration);
            }
        }
        toolBar.revalidate();
        return toolBar;
    }

    private boolean isFloatable() {
        return this.description.isFloatable();
    }

    private AbstractButton addToToolBar(JToolBar toolBar, ToolBarItemConfiguration toolBarItemConfiguration) {
        if (toolBarItemConfiguration.hasActionContainerProvider()) {
            IActionContainerProvider<? extends Container> actionContainerProvider = toolBarItemConfiguration.getActionContainerProvider();
            toolBar.add(actionContainerProvider.getContainer());
            return actionContainerProvider.getButton();
        }
        return toolBar.add(toolBarItemConfiguration.getAction());
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public static final class ActionDisabler
    implements ActionListener {
        private final List<Action> actions;

        public ActionDisabler(List<Action> actions) {
            this.actions = actions;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (Action action : this.actions) {
                action.setEnabled(true);
            }
            Object source = event.getSource();
            if (source instanceof AbstractButton) {
                ((AbstractButton)source).getAction().setEnabled(false);
            }
        }
    }

    public static final class ToolBarItemGroupDescriptionComparator
    implements Comparator<ToolBarItemGroupDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ToolBarItemGroupDescription o1, ToolBarItemGroupDescription o2) {
            return Integer.valueOf(o1.getWeight()).compareTo(o2.getWeight());
        }
    }
}

