/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import net.anwiba.commons.swing.transform.IPoint2DTransformer;

public abstract class AbstractPoint2DTransformer
implements IPoint2DTransformer {
    @Override
    public Point2D transform(Point2D point) throws NoninvertibleTransformException {
        Point2D.Double transformedPoint = new Point2D.Double();
        this.getAffinTransform().transform(point, transformedPoint);
        return transformedPoint;
    }

    @Override
    public Point2D inverseTransform(Point2D point) throws NoninvertibleTransformException {
        Point2D.Double transformedPoint = new Point2D.Double();
        this.getAffinTransform().inverseTransform(point, transformedPoint);
        return transformedPoint;
    }

    @Override
    public IPoint2DTransformer getScaledInstance(double scale) {
        AffineTransform affinTransform = this.getAffinTransform();
        AffineTransform scaled = new AffineTransform(affinTransform);
        scaled.scale(scale, -scale);
        return new Point2DTransformer(scaled);
    }

    protected abstract AffineTransform getAffinTransform();

    public static final class Point2DTransformer
    extends AbstractPoint2DTransformer {
        private final AffineTransform scaled;

        public Point2DTransformer(AffineTransform scaled) {
            this.scaled = scaled;
        }

        @Override
        protected AffineTransform getAffinTransform() {
            return this.scaled;
        }
    }
}

