/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.anwiba.commons.lang.functional.IFactory;

public class LazyFolderTreeNode<T>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private boolean isInitialize = false;
    private final IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer;

    public LazyFolderTreeNode(IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer, T string) {
        super(string);
        this.initializer = initializer;
    }

    public boolean isInitialize() {
        return this.isInitialize;
    }

    public void reset() {
        if (!this.isInitialize) {
            return;
        }
        this.children = null;
        this.isInitialize = false;
    }

    private void initialize() {
        if (this.isInitialize) {
            return;
        }
        List list = (List)this.initializer.create(this.getUserObject());
        this.children = new Vector(list);
        this.isInitialize = true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        this.initialize();
        super.insert(newChild, childIndex);
    }

    @Override
    public TreeNode getChildAt(int index) {
        this.initialize();
        return super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        this.initialize();
        return super.getChildCount();
    }

    @Override
    public Enumeration<TreeNode> children() {
        this.initialize();
        return super.children();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

