/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.tree;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class ReloadableFolderTreeNode<T>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = Logging.getLogger((String)ReloadableFolderTreeNode.class.getName());
    private boolean isInitialize = false;
    private final IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer;

    public ReloadableFolderTreeNode(IFactory<T, List<DefaultMutableTreeNode>, RuntimeException> initializer, T userObject) {
        super(userObject);
        this.initializer = initializer;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.isInitialize = true;
        super.add(newChild);
    }

    public boolean isInitialize() {
        return this.isInitialize;
    }

    public void reset() {
        if (!this.isInitialize) {
            return;
        }
        this.children = null;
        this.isInitialize = false;
    }

    public void load(final DefaultTreeModel treeModel) {
        if (this.isInitialize(true)) {
            return;
        }
        SwingWorker<List<DefaultMutableTreeNode>, Void> worker = new SwingWorker<List<DefaultMutableTreeNode>, Void>(){

            @Override
            protected List<DefaultMutableTreeNode> doInBackground() throws Exception {
                return (List)ReloadableFolderTreeNode.this.initializer.create(ReloadableFolderTreeNode.this.getUserObject());
            }

            @Override
            protected void done() {
                try {
                    ReloadableFolderTreeNode.this.children = new Vector((Collection)this.get());
                    treeModel.nodeStructureChanged(ReloadableFolderTreeNode.this);
                    super.done();
                }
                catch (InterruptedException exception) {
                    super.done();
                }
                catch (ExecutionException exception) {
                    logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    super.done();
                }
            }
        };
        worker.execute();
    }

    private synchronized boolean isInitialize(boolean value) {
        boolean initialize = this.isInitialize;
        this.isInitialize = value;
        return initialize;
    }
}

