/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.ui;

import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icon.IGuiIconDecoration;
import net.anwiba.commons.swing.icons.GuiIcons;

public enum GuiIconDecoration implements IGuiIconDecoration
{
    NONE((IGuiIcon)GuiIcons.EMPTY_ICON),
    INFO((IGuiIcon)GuiIcons.INFORMATION_ICON),
    WARNING((IGuiIcon)GuiIcons.WARNING_DECORATION),
    ERROR((IGuiIcon)GuiIcons.ERROR_DECORATION),
    FILTER((IGuiIcon)GuiIcons.FILTER_DECORATION),
    QUERY((IGuiIcon)GuiIcons.QUERY_ICON);

    private final IGuiIcon decoration;

    private GuiIconDecoration(IGuiIcon decoration) {
        this.decoration = decoration;
    }

    public IGuiIcon getGuiIcon() {
        return this.decoration;
    }

    public static GuiIconDecoration getByMessageType(MessageType messageType) {
        if (messageType == null) {
            return NONE;
        }
        switch (messageType) {
            case DEFAULT: {
                return NONE;
            }
            case QUERY: {
                return QUERY;
            }
            case INFO: {
                return INFO;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
        }
        throw new UnreachableCodeReachedException();
    }
}

