/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.html.HTMLDocument;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class JTextComponentUtilities {
    private static ILogger logger = Logging.getLogger((String)JTextComponentUtilities.class.getName());

    public static void setTextAndMoveToTop(JTextComponent textPane, String text) {
        Document document = textPane.getDocument();
        if (document instanceof PlainDocument) {
            JTextComponentUtilities.setTextToDocument((PlainDocument)document, text);
        } else {
            GuiUtilities.invokeLater(() -> textPane.setText(text));
        }
        GuiUtilities.invokeLater(() -> textPane.setCaretPosition(0));
    }

    public static void setTextToDocument(PlainDocument document, String text) {
        GuiUtilities.invokeLater(() -> {
            try {
                document.replace(0, document.getLength(), text, null);
            }
            catch (BadLocationException exception) {
                logger.log(ILevel.FATAL, exception.getLocalizedMessage(), (Throwable)exception);
            }
        });
    }

    public static double getValueWidth(Component component, String value) {
        Font font = component.getFont();
        FontRenderContext fontRenderContext = component.getFontMetrics(font).getFontRenderContext();
        return font.getStringBounds(value, fontRenderContext).getWidth();
    }

    public static double getValueWidth(Graphics graphics, String value) {
        Font font = graphics.getFont();
        FontRenderContext fontRenderContext = graphics.getFontMetrics(font).getFontRenderContext();
        return font.getStringBounds(value, fontRenderContext).getWidth();
    }

    public static void enableHyperlinks(JEditorPane area) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && area.getDocument() instanceof HTMLDocument && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            area.addHyperlinkListener(hyperlinkEvent -> {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String descriptionString = hyperlinkEvent.getDescription();
                    logger.log(ILevel.DEBUG, "href '" + descriptionString + "'");
                    try {
                        URL url = hyperlinkEvent.getURL();
                        if (url != null) {
                            logger.log(ILevel.DEBUG, "href '" + url + "'");
                            desktop.browse(url.toURI());
                        } else if (descriptionString != null) {
                            File file = new File(descriptionString);
                            URI uri = file.getAbsoluteFile().toURI();
                            desktop.browse(uri);
                        }
                    }
                    catch (IOException | URISyntaxException exception) {
                        logger.log(ILevel.WARNING, "Couldn't browse '" + descriptionString + "'");
                        logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    }
                }
            });
        }
    }
}

