/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.utilities;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class JTreeUtilities {
    public static void expandAll(JTree tree, DefaultMutableTreeNode node) {
        GuiUtilities.invokeLater(() -> JTreeUtilities.internalExpandAll(tree, node));
    }

    static void internalExpandAll(JTree tree, DefaultMutableTreeNode node) {
        tree.expandPath(new TreePath(node.getPath()));
        for (int i = 0; i < node.getChildCount(); ++i) {
            JTreeUtilities.internalExpandAll(tree, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    public static void expandAll(JTree tree) {
        GuiUtilities.invokeLater(() -> JTreeUtilities.internalExpandAll(tree));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalExpandAll(JTree tree) {
        JTree jTree = tree;
        synchronized (jTree) {
            for (int row = 0; row < tree.getRowCount(); ++row) {
                tree.expandRow(row);
            }
        }
    }

    public static void collapseAll(JTree tree) {
        GuiUtilities.invokeLater(() -> JTreeUtilities.internalCollapseAll(tree));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalCollapseAll(JTree tree) {
        JTree jTree = tree;
        synchronized (jTree) {
            for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                tree.collapseRow(row);
            }
        }
    }

    public static void selectFirstLeaf(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        TreePath treePath = new TreePath(node.getFirstLeaf().getPath());
        JTreeUtilities.selectPath(tree, treePath);
    }

    private static void selectPath(JTree tree, TreePath treePath) {
        GuiUtilities.invokeLater(() -> {
            tree.getSelectionModel().setSelectionPath(treePath);
            tree.scrollPathToVisible(treePath);
        });
    }

    public static void selectFirstNode(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        TreeNode childNode = node.getFirstChild();
        if (childNode instanceof DefaultMutableTreeNode) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)childNode).getPath());
            JTreeUtilities.selectPath(tree, treePath);
        }
    }

    public static void insertNode(DefaultTreeModel model, JTree tree, DefaultMutableTreeNode root, DefaultMutableTreeNode node, int index) {
        JTreeUtilities.internalInsertNode(model, tree, root, node, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalInsertNode(DefaultTreeModel model, JTree tree, DefaultMutableTreeNode root, DefaultMutableTreeNode node, int index) {
        JTree jTree = tree;
        synchronized (jTree) {
            if (index < 0) {
                model.insertNodeInto(node, root, root.getChildCount());
            } else if (index >= root.getChildCount()) {
                model.insertNodeInto(node, root, index);
            } else {
                model.insertNodeInto(node, root, index);
            }
            JTreeUtilities.selectPath(tree, new TreePath(node.getPath()));
        }
    }
}

