/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.demo;

import java.awt.Window;
import javax.swing.Icon;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.testing.demo.JDialogs;
import org.junit.jupiter.api.Test;

public class MessageDialogDemo {
    @Test
    public void demoDefault() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text", (MessageType)MessageType.DEFAULT), null, DialogType.CLOSE));
    }

    @Test
    public void demoDefaultWithIcon() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text", (MessageType)MessageType.DEFAULT), (Icon)GuiIcons.GLOBE_ICON.getLargeIcon(), DialogType.CLOSE));
    }

    @Test
    public void demoInfo() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text", (MessageType)MessageType.INFO), null, DialogType.CLOSE));
    }

    @Test
    public void demoInfoWithLongDescription() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text, mit ganz lange Text. Eigentlich nur ein Text der \ufffdber mehrere Spalten gehen soll.", (MessageType)MessageType.INFO), null, DialogType.CLOSE));
    }

    @Test
    public void demoInfoWithEmptyDescription() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", null, (MessageType)MessageType.INFO), null, DialogType.CLOSE));
    }

    @Test
    public void demoWarning() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text", (MessageType)MessageType.WARNING), null, DialogType.CLOSE));
    }

    @Test
    public void demoError() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text", (MessageType)MessageType.ERROR), null, DialogType.CLOSE));
    }

    @Test
    public void demoCancelOk() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text"), null, DialogType.CANCEL_OK));
    }

    @Test
    public void demoCancelApplyOk() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Information Label", (String)"Description Text"), null, DialogType.CANCEL_APPLY_OK));
    }

    @Test
    public void demoQuery() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Query Label", (String)"Description Text", (MessageType)MessageType.QUERY), null, DialogType.YES_NO));
    }

    @Test
    public void demoDetails() {
        JDialogs.show(frame -> new MessageDialog((Window)frame, "Title", Message.create((String)"Query Label", (String)"Description Text", (MessageType)MessageType.QUERY), null, DialogType.CLOSE_DETIALS));
    }
}

