/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.icons;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.swing.icon.MutableImageIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.testing.demo.DemoUtilities;
import net.anwiba.testing.demo.JFrames;
import org.junit.jupiter.api.Test;

public class MutableIconDemo {
    @Test
    public void simpleDemo() {
        MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        JFrames.show((Icon)icon);
    }

    @Test
    public void complexDemo() {
        MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        final JLabel label = new JLabel((Icon)icon);
        icon.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                label.repaint();
            }
        });
        JFrames.show((JComponent)label, frame -> {
            DemoUtilities.pause();
            icon.getModel().set((Object)GuiIcons.ADD_ICON.getLargeIcon());
            DemoUtilities.pause();
            icon.getModel().set((Object)GuiIcons.CLOSE_ICON.getLargeIcon());
            DemoUtilities.pause();
        });
    }

    @Test
    public void complexDemoWithAction() {
        MutableImageIcon icon = new MutableImageIcon(GuiIcons.MISC_ICON.getLargeIcon());
        AbstractAction action = new AbstractAction(null, (Icon)icon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        final JButton button = new JButton(action);
        icon.getModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                button.repaint();
            }
        });
        JFrames.show((JComponent)button, frame -> {
            DemoUtilities.pause();
            icon.getModel().set((Object)GuiIcons.ADD_ICON.getLargeIcon());
            DemoUtilities.pause();
            icon.getModel().set((Object)GuiIcons.CLOSE_ICON.getLargeIcon());
            DemoUtilities.pause();
        });
    }

    @Test
    public void complexDemoWithActionAndNormalIcon() {
        AbstractAction action = new AbstractAction(null, GuiIcons.MISC_ICON.getLargeIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        JButton button = new JButton(action);
        JFrames.show((JComponent)button, frame -> {
            DemoUtilities.pause();
            action.putValue("SmallIcon", GuiIcons.ADD_ICON.getLargeIcon());
            DemoUtilities.pause();
            action.putValue("SmallIcon", GuiIcons.CLOSE_ICON.getLargeIcon());
            DemoUtilities.pause();
        });
    }
}

