/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.combobox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.border.Border;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.swing.combobox.IComboBoxModel;
import net.anwiba.commons.swing.combobox.ObjectComboBox;
import net.anwiba.commons.swing.combobox.ObjectComboBoxModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ObjectComboBoxBuilder<T> {
    final ObjectListConfigurationBuilder<T> configurationBuilder = new ObjectListConfigurationBuilder();
    private IComboBoxModel<T> model;
    private T value = null;

    public ObjectComboBoxBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.configurationBuilder.setObjectUi(objectUi);
        return this;
    }

    public ObjectComboBoxBuilder<T> setPrototype(T prototype) {
        this.configurationBuilder.setPrototype(prototype);
        return this;
    }

    public ObjectComboBoxBuilder<T> setSingleSelectionMode() {
        this.configurationBuilder.setSingleSelectionMode();
        return this;
    }

    public ObjectComboBoxBuilder<T> setSingleIntervalSelectionMode() {
        this.configurationBuilder.setSingleIntervalSelectionMode();
        return this;
    }

    public ObjectComboBoxBuilder<T> setMultiSelectionMode() {
        this.configurationBuilder.setMultiSelectionMode();
        return this;
    }

    public ObjectComboBoxBuilder<T> setIconTextGap(int iconTextGap) {
        this.configurationBuilder.setIconTextGap(iconTextGap);
        return this;
    }

    public ObjectComboBoxBuilder<T> setVerticalTextPosition(int verticalTextPosition) {
        this.configurationBuilder.setVerticalTextPosition(verticalTextPosition);
        return this;
    }

    public ObjectComboBoxBuilder<T> setHorizontalTextPosition(int horizontalTextPosition) {
        this.configurationBuilder.setHorizontalTextPosition(horizontalTextPosition);
        return this;
    }

    public ObjectComboBoxBuilder<T> setVerticalAlignment(int verticalAlignment) {
        this.configurationBuilder.setVerticalAlignment(verticalAlignment);
        return this;
    }

    public ObjectComboBoxBuilder<T> setHorizontalAlignment(int horizontalAlignment) {
        this.configurationBuilder.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public ObjectComboBoxBuilder<T> setBorder(Border border) {
        this.configurationBuilder.setBorder(border);
        return this;
    }

    public ObjectComboBoxBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.configurationBuilder.setVisibleRowCount(visibleRowCount);
        return this;
    }

    public ObjectComboBoxBuilder<T> setModel(IComboBoxModel<T> model) {
        this.model = model;
        return this;
    }

    public ObjectComboBoxBuilder<T> setValues(T[] values) {
        this.setValues(Arrays.asList(values));
        return this;
    }

    public ObjectComboBoxBuilder<T> setValues(List<T> values) {
        this.model = new ObjectComboBoxModel<T>(values);
        return this;
    }

    public ObjectComboBoxBuilder<T> setSelectedValue(T value) {
        this.value = value;
        return this;
    }

    public ObjectComboBoxBuilder<T> setEnabledModel(IBooleanDistributor enabledModel) {
        this.configurationBuilder.setEnabledModel(enabledModel);
        return this;
    }

    public ObjectComboBoxBuilder<T> setEditable(boolean isEditable) {
        this.configurationBuilder.setEditable(isEditable);
        return this;
    }

    public ObjectComboBoxBuilder<T> setEditableEnabled() {
        this.configurationBuilder.setEditable(true);
        return this;
    }

    public ObjectComboBoxBuilder<T> setEditableDisabled() {
        this.configurationBuilder.setEditable(false);
        return this;
    }

    public ObjectComboBox<T> build() {
        IComboBoxModel model = Optional.ofNullable(this.model).orElseGet(() -> new ObjectComboBoxModel(new ArrayList()));
        model.setSelectedItem(this.value);
        return new ObjectComboBox<T>(this.configurationBuilder.build(), model);
    }
}

