/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.anwiba.commons.swing.component.GridBagLayoutComponent;
import net.anwiba.commons.swing.component.IGridBagLayoutComponent;

public class GridBagLayoutComponentBuilder {
    private static final int UNDEFIND_ANCHOR = -1;
    private final List<IGridBagLayoutComponent> components = new ArrayList<IGridBagLayoutComponent>(10);
    private int row = 0;
    private int column = -1;
    private int maximunsNumberOfColumns = -1;
    private Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private final Insets insets = new Insets(4, 4, 0, 0);

    public GridBagLayoutComponentBuilder header(String text) {
        this.newline();
        JLabel label = new JLabel(text + (text.isEmpty() ? "" : ":"));
        label.setVerticalTextPosition(1);
        label.setVerticalAlignment(1);
        label.setHorizontalTextPosition(2);
        label.setHorizontalAlignment(2);
        label.setFont(label.getFont().deriveFont(1, label.getFont().getSize() + 2));
        this.components.add(new GridBagLayoutComponent(label, ++this.column, this.row, 1, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder newlineAndLabel(String text) {
        this.newline();
        JLabel label = new JLabel(text + (text.isEmpty() ? "" : ":"));
        label.setVerticalTextPosition(1);
        label.setVerticalAlignment(1);
        label.setHorizontalTextPosition(2);
        label.setHorizontalAlignment(2);
        this.components.add(new GridBagLayoutComponent(label, ++this.column, this.row, 1, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder label(String text) {
        return this.add(new JLabel(text + (text.isEmpty() ? "" : ":")));
    }

    public GridBagLayoutComponentBuilder add(Action action) {
        return this.add(new JButton(action));
    }

    public GridBagLayoutComponentBuilder add(JComponent component) {
        this.components.add(new GridBagLayoutComponent(component, ++this.column, this.row, 1, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder add(JComponent component, int with) {
        int componentColumn = this.column + 1;
        this.column += with;
        this.components.add(new GridBagLayoutComponent(component, componentColumn, this.row, with, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder placeHolder() {
        this.add(new JPanel());
        return this;
    }

    public GridBagLayoutComponentBuilder newline() {
        this.maximunsNumberOfColumns = Math.max(this.maximunsNumberOfColumns, this.column);
        this.column = -1;
        ++this.row;
        return this;
    }

    public GridBagLayoutComponentBuilder emptyLine() {
        if (this.column > -1) {
            this.newline();
        }
        this.components.add(new GridBagLayoutComponent(new JLabel(" "), ++this.column, this.row, 1, 1, -1));
        this.newline();
        return this;
    }

    public GridBagLayoutComponentBuilder setBorder(Border border) {
        this.border = border;
        return this;
    }

    public JComponent build() {
        if (this.components.isEmpty()) {
            return new JPanel();
        }
        if (this.components.size() == 1) {
            return this.components.get(0).getComponent();
        }
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(this.border);
        for (IGridBagLayoutComponent component : this.components) {
            contentPanel.add((Component)component.getComponent(), component.getConstraints(this.insets));
        }
        return contentPanel;
    }
}

