/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Component;
import java.awt.Window;
import net.anwiba.commons.message.ExceptionMessage;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.icon.IGuiIcon;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class MessageDialogUtilities {
    public static final IDialogResult show(Component owner, IMessage message) {
        return MessageDialogUtilities.show(owner, message.getText(), message);
    }

    public static final IDialogResult show(Component owner, String title, IMessage message) {
        return MessageDialogUtilities.show(owner, title, message, DialogType.CLOSE);
    }

    public static IDialogResult show(Component owner, String title, IMessage message, DialogType dialogType) {
        return MessageDialogUtilities.show(owner, title, message, (IGuiIcon)GuiIcons.EMPTY_ICON, dialogType);
    }

    private static IDialogResult show(Component owner, String title, IMessage message, IGuiIcon icon, DialogType dialogType) {
        return MessageDialogUtilities.launch(GuiUtilities.getParentWindow(owner), title, message, icon, dialogType);
    }

    public static IDialogResult showUnsupportedOperationDialog(Window owner) {
        return MessageDialogUtilities.show(owner, DialogMessages.ERROR, Message.create((String)"Unsupported operation", (String)"Not yet implemented"), (IGuiIcon)GuiIcons.EMPTY_ICON, DialogType.CLOSE);
    }

    private static IDialogResult launch(Window owner, String title, IMessage message, IGuiIcon icon, DialogType dialogType) {
        return MessageDialog.launcher().title(title).icon(icon).message(message).dialogType(dialogType).launch(owner);
    }

    public static void show(Window owner, ExceptionMessage message) {
        MessageDialog.launcher().message((IMessage)message).launch(owner);
    }

    public static void show(Window owner, Throwable e) {
        MessageDialog.launcher().throwable(e).error().launch(owner);
    }
}

