/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.pane;

import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.pane.IContentPanel;

public abstract class AbstractContentPane
implements IContentPanel {
    private final IObjectModel<IMessage> messageModel = new ObjectModel();
    private final IObjectModel<DataState> dataStateModel;

    public AbstractContentPane(IObjectModel<DataState> dataStateModel) {
        this.dataStateModel = dataStateModel;
    }

    @Override
    public IObjectModel<DataState> getDataStateModel() {
        return this.dataStateModel;
    }

    @Override
    public IObjectModel<IMessage> getMessageModel() {
        return this.messageModel;
    }

    protected void invalid(IMessage message) {
        this.getDataStateModel().set((Object)DataState.INVALIDE);
        this.getMessageModel().set((Object)message);
    }

    protected void valid() {
        this.getDataStateModel().set((Object)DataState.VALIDE);
        this.getMessageModel().set(null);
    }

    protected void modified() {
        this.getDataStateModel().set((Object)DataState.MODIFIED);
        this.getMessageModel().set(null);
    }

    protected void unknown() {
        this.getDataStateModel().set((Object)DataState.UNKNOWN);
        this.getMessageModel().set(null);
    }

    @Override
    public boolean apply() {
        return true;
    }

    @Override
    public boolean tryOut() {
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void close() {
    }
}

