/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.exception;

import java.text.MessageFormat;
import java.util.Objects;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.swing.exception.IExceptionHandler;
import net.anwiba.commons.swing.exception.InternalExceptionHandler;
import net.anwiba.commons.utilities.OperationSystemUtilities;

public class CentralExceptionHandling {
    private static ILogger logger = Logging.getLogger((String)CentralExceptionHandling.class.getName());
    private static final CentralExceptionHandling instance = new CentralExceptionHandling();
    private IExceptionHandler handler;

    private CentralExceptionHandling() {
        this.attachForEventDispatchExceptionHandling();
        this.attachForThreadUncaughtExceptionHandling();
    }

    private void attachForThreadUncaughtExceptionHandling() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (OperationSystemUtilities.isLinux() && e instanceof IllegalArgumentException && t.getClass().getName().endsWith("EventDispatchThread") && Objects.equals(e.getMessage(), "Width and height must be >= 0") && stackTraceElements.length > 1 && Objects.equals(stackTraceElements[0].getClassName(), "javax.swing.plaf.basic.BasicHTML") && Objects.equals(stackTraceElements[0].getMethodName(), "getHTMLBaseline")) {
                    if (logger.isLoggable(ILevel.FINE)) {
                        CentralExceptionHandling.this.handle(new RuntimeException(MessageFormat.format("Uncaught exception on thread [{0}]", t.getName()), e));
                    }
                    return;
                }
                CentralExceptionHandling.this.handle(new RuntimeException(MessageFormat.format("Uncaught exception on thread [{0}]", t.getName()), e));
            }
        });
    }

    public IExceptionHandler getHandler() {
        return this.handler;
    }

    public static void setHandler(IExceptionHandler handler) {
        CentralExceptionHandling.getInstance().handler = handler;
    }

    public static CentralExceptionHandling getInstance() {
        return instance;
    }

    public void handle(Throwable exception) {
        if (this.handler != null) {
            this.handler.handle(exception);
        } else {
            logger.log(ILevel.FATAL, exception.getMessage(), exception);
        }
    }

    private void attachForEventDispatchExceptionHandling() {
        System.setProperty("sun.awt.exception.handler", InternalExceptionHandler.class.getName());
    }
}

