/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.layout;

import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import net.anwiba.commons.swing.layout.Anchor;
import net.anwiba.commons.swing.layout.OverlayConstraints;

public class OverlayConstraintsBuilder {
    private final Set<Anchor> anchors = new HashSet<Anchor>();
    private int top = 0;
    private int left = 0;
    private int bottom = 0;
    private int right = 0;
    private double topFactor = Double.NaN;
    private double leftFactor = Double.NaN;
    private double bottomFactor = Double.NaN;
    private double rightFactor = Double.NaN;
    private double widthFactor = Double.NaN;
    private double heightFactor = Double.NaN;

    public OverlayConstraintsBuilder addAnchorToLeft() {
        this.anchors.add(Anchor.LEFT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToLeft(int distance) {
        this.setLeftBorder(distance);
        this.anchors.add(Anchor.LEFT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToLeft(double distanceFactor) {
        this.setLeftFactor(distanceFactor);
        this.anchors.add(Anchor.LEFT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToRight() {
        this.anchors.add(Anchor.RIGHT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToRight(int distance) {
        this.setRightBorder(distance);
        this.anchors.add(Anchor.RIGHT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToRight(double distanceFactor) {
        this.setRightBorderFactor(distanceFactor);
        this.anchors.add(Anchor.RIGHT);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToTop() {
        this.anchors.add(Anchor.TOP);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToTop(int distance) {
        this.setTopBorder(distance);
        this.anchors.add(Anchor.TOP);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToTop(double distanceFactor) {
        this.setTopFactor(distanceFactor);
        this.anchors.add(Anchor.TOP);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToBottom() {
        this.anchors.add(Anchor.BUTTOM);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToBottom(int distance) {
        this.setButtomBorder(distance);
        this.anchors.add(Anchor.BUTTOM);
        return this;
    }

    public OverlayConstraintsBuilder addAnchorToBottom(double distanceFactor) {
        this.setBottomFactor(distanceFactor);
        this.anchors.add(Anchor.BUTTOM);
        return this;
    }

    public OverlayConstraintsBuilder setHorizontelFilling() {
        this.addAnchorToLeft();
        this.addAnchorToRight();
        return this;
    }

    public OverlayConstraintsBuilder setVerticalFilling() {
        this.addAnchorToTop();
        this.addAnchorToBottom();
        return this;
    }

    public OverlayConstraintsBuilder setFullFilling() {
        this.addAnchorToTop();
        this.addAnchorToBottom();
        this.addAnchorToLeft();
        this.addAnchorToRight();
        return this;
    }

    public OverlayConstraintsBuilder setRightBorder(int width) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.right = width;
        return this;
    }

    public OverlayConstraintsBuilder setLeftBorder(int width) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.left = width;
        return this;
    }

    public OverlayConstraintsBuilder setTopBorder(int width) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.top = width;
        return this;
    }

    public OverlayConstraintsBuilder setButtomBorder(int width) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.bottom = width;
        return this;
    }

    public OverlayConstraintsBuilder setRightBorderFactor(double width) {
        if (!Double.isNaN(width) && (width < 0.0 || width > 1.0)) {
            throw new IllegalArgumentException();
        }
        this.rightFactor = width;
        return this;
    }

    public OverlayConstraintsBuilder setLeftFactor(double width) {
        if (!Double.isNaN(width) && (width < 0.0 || width > 1.0)) {
            throw new IllegalArgumentException();
        }
        this.leftFactor = width;
        return this;
    }

    public OverlayConstraintsBuilder setTopFactor(double width) {
        if (!Double.isNaN(width) && (width < 0.0 || width > 1.0)) {
            throw new IllegalArgumentException();
        }
        this.topFactor = width;
        return this;
    }

    public OverlayConstraintsBuilder setBottomFactor(double width) {
        if (!Double.isNaN(width) && (width < 0.0 || width > 1.0)) {
            throw new IllegalArgumentException();
        }
        this.bottomFactor = width;
        return this;
    }

    public OverlayConstraintsBuilder setBorder(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        return this;
    }

    public OverlayConstraints build() {
        return new OverlayConstraints(this.anchors, new Insets(this.top, this.left, this.bottom, this.right), this.topFactor, this.leftFactor, this.bottomFactor, this.rightFactor, this.widthFactor, this.heightFactor);
    }

    public OverlayConstraintsBuilder setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
        return this;
    }

    public OverlayConstraintsBuilder setHeightFactor(double heightFactor) {
        this.heightFactor = heightFactor;
        return this;
    }
}

