/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.util.function.Function;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.swing.icons.gnome.contrast.high.ContrastHightIcons;
import net.anwiba.commons.swing.object.AbstractAlgebraicObjectFieldBuilder;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IntegerField;
import net.anwiba.commons.swing.object.IntegerObjectFieldConfigurationBuilder;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class IntegerFieldBuilder
extends AbstractAlgebraicObjectFieldBuilder<Integer, IntegerObjectFieldConfigurationBuilder, IntegerFieldBuilder> {
    public IntegerFieldBuilder() {
        super(new IntegerObjectFieldConfigurationBuilder());
    }

    @Override
    protected AbstractObjectTextField<Integer> create(IObjectFieldConfiguration<Integer> configuration) {
        return new IntegerField(configuration);
    }

    public IntegerFieldBuilder addModuloSpinnerActions(int m, int step) {
        return this.addModuloSpinnerActions(m, step, 250, 100);
    }

    public IntegerFieldBuilder addModuloSpinnerActions(int m, int step, int initialDelay, int delay) {
        Function<Integer, Integer> minus = input -> (Integer)Optional.of((Object)input).convert(v1 -> (v1 - step) % m).convert(v2 -> v2 < 0 ? v2 + m : v2).convert(v3 -> v3 >= m ? v3 - m : v3).getOr(() -> m - step);
        Function<Integer, Boolean> minusEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Integer, Integer> add = input -> (Integer)Optional.of((Object)input).convert(v1 -> (v1 + step) % m).convert(v2 -> v2 < 0 ? v2 + m : v2).convert(v3 -> v3 >= m ? v3 - m : v3).getOr(() -> 0);
        Function<Integer, Boolean> addEnabler = input -> true;
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    public IntegerFieldBuilder addSpinnerActions(int minimum, int maximum, int step) {
        return this.addSpinnerActions(minimum, maximum, step, 250, 100);
    }

    public IntegerFieldBuilder addSpinnerActions(int minimum, int maximum, int step, int initialDelay, int delay) {
        this.addValidatorFactory(converter -> value -> (IValidationResult)Optional.of((Object)value).convert(v1 -> (Integer)converter.convert(v1)).convert(v2 -> this.isValid((Integer)v2, minimum, maximum)).getOr(() -> IValidationResult.valid()));
        Function<Integer, Integer> minus = input -> (Integer)Optional.of((Object)input).convert(v1 -> v1 - step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> maximum);
        Function<Integer, Boolean> minusEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 > minimum & minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.MINUS, minus, minusEnabler, initialDelay, delay));
        Function<Integer, Integer> add = input -> (Integer)Optional.of((Object)input).convert(v1 -> v1 + step).convert(v2 -> v2 < minimum ? minimum : v2).convert(v3 -> v3 > maximum ? maximum : v3).getOr(() -> minimum);
        Function<Integer, Boolean> addEnabler = input -> (Boolean)Optional.of((Object)input).convert(v4 -> v4 < maximum & minimum < maximum).getOr(() -> true);
        this.addButtonFactory(this.createButton(ContrastHightIcons.ADD, add, addEnabler, initialDelay, delay));
        return this;
    }

    public IValidationResult isValid(Integer value, int minimum, int maximum) {
        return value < minimum ? IValidationResult.inValid((String)(value + " < " + minimum)) : (value > maximum ? IValidationResult.inValid((String)(value + " > " + maximum)) : IValidationResult.valid());
    }
}

