/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.math.BigDecimal;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.AbstractObjectTextField;
import net.anwiba.commons.swing.object.DefaultObjectFieldConfiguration;
import net.anwiba.commons.swing.object.IObjectFieldConfiguration;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class NumberField
extends AbstractObjectTextField<Number> {
    public NumberField(IObjectFieldConfiguration<Number> objectFieldConfiguration) {
        super(objectFieldConfiguration);
        this.setHorizontalAlignment(4);
    }

    public NumberField() {
        this((IObjectFieldConfiguration<Number>)new DefaultObjectFieldConfiguration<Number>((IObjectModel<Number>)new ObjectModel(), (IObjectModel<IValidationResult>)new ObjectModel((Object)IValidationResult.valid()), new IValidator<String>(){

            public IValidationResult validate(String value) {
                return IValidationResult.valid();
            }
        }, c -> true, new IConverter<String, Number, RuntimeException>(){

            public Number convert(String number) {
                if (StringUtilities.isNullOrTrimmedEmpty((String)number)) {
                    return null;
                }
                return new BigDecimal(number);
            }
        }, new IConverter<Number, String, RuntimeException>(){

            public String convert(Number number) {
                if (number == null) {
                    return null;
                }
                return number.toString();
            }
        }));
    }
}

