/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.anwiba.commons.lang.functional.ICharFilter;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.IObjectProvider;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.lang.object.ObjectContainer;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.object.AbstractObjectTextFieldConfiguration;
import net.anwiba.commons.swing.object.IActionFactory;
import net.anwiba.commons.utilities.validation.AllwaysValidStringValidator;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public class ObjectFieldConfiguration
extends AbstractObjectTextFieldConfiguration<Object> {
    private final IConverter<String, Object, RuntimeException> stringToObjectConverter;
    private final IConverter<Object, String, RuntimeException> objectToStringConverter;
    private final ICharFilter characterFilter;

    public ObjectFieldConfiguration(IObjectModel<Object> model, IObjectModel<IValidationResult> validStateModel, boolean isEditable, int columns, List<IActionFactory<Object>> actionFactorys, Color backgroundColor) {
        super(model, validStateModel, null, (IBooleanModel)new BooleanModel(true), isEditable, columns, actionFactorys, Collections.emptyList(), null, backgroundColor, false);
        ObjectContainer broker = new ObjectContainer();
        this.characterFilter = c -> true;
        this.stringToObjectConverter = new StringToObjectConverter((IObjectProvider<Object>)broker);
        this.objectToStringConverter = new ObjectToStringConverter((IObjectReceiver<Object>)broker);
    }

    @Override
    public IConverter<String, Object, RuntimeException> getToObjectConverter() {
        return this.stringToObjectConverter;
    }

    @Override
    public IConverter<Object, String, RuntimeException> getToStringConverter() {
        return this.objectToStringConverter;
    }

    @Override
    public IValidator<String> getValidator() {
        return new AllwaysValidStringValidator();
    }

    @Override
    public ICharFilter getCharacterFilter() {
        return this.characterFilter;
    }

    static final class StringToObjectConverter
    implements IConverter<String, Object, RuntimeException> {
        private final IObjectProvider<Object> provider;

        public StringToObjectConverter(IObjectProvider<Object> provider) {
            this.provider = provider;
        }

        public Object convert(String input) {
            if (this.provider.get() == null) {
                return input;
            }
            return this.provider.get();
        }
    }

    static final class ObjectToStringConverter
    implements IConverter<Object, String, RuntimeException> {
        private final IObjectReceiver<Object> receiver;

        public ObjectToStringConverter(IObjectReceiver<Object> receiver) {
            this.receiver = receiver;
        }

        public String convert(Object input) {
            this.receiver.set(input);
            if (input == null) {
                return "";
            }
            return input.toString();
        }
    }
}

