/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.object;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.IObjectLabel;
import net.anwiba.commons.swing.ui.IObjectUi;
import net.anwiba.commons.swing.ui.ObjectUiBuilder;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class ObjectLabelBuilder<T> {
    private IObjectUi<T> objectUi = new ObjectUiBuilder().text(object -> (String)Optional.of((Object)object).convert(o -> o.toString()).get()).build();
    private IObjectModel<T> model = new ObjectModel();

    public ObjectLabelBuilder<T> setModel(IObjectModel<T> model) {
        this.model = model;
        return this;
    }

    public ObjectLabelBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.objectUi = objectUi;
        return this;
    }

    public IObjectLabel<T> build() {
        return new ObjectLabel<T>(this.model, this.objectUi);
    }

    public static final class ObjectLabel<T>
    implements IObjectLabel<T> {
        private final IObjectModel<T> model;
        private final IObjectUi<T> objectUi;

        public ObjectLabel(IObjectModel<T> model, IObjectUi<T> objectUi) {
            this.model = model;
            this.objectUi = objectUi;
        }

        @Override
        public JComponent getComponent() {
            JLabel label = new JLabel(this.objectUi.getText(this.model.get()), this.objectUi.getIcon(this.model.get()), 10);
            label.setToolTipText(this.objectUi.getToolTipText(this.model.get()));
            this.model.addChangeListener(() -> GuiUtilities.invokeLater(() -> {
                label.setIcon(this.objectUi.getIcon(this.model.get()));
                label.setText(this.objectUi.getText(this.model.get()));
                label.setToolTipText(this.objectUi.getToolTipText(this.model.get()));
            }));
            return label;
        }

        @Override
        public IObjectReceiver<T> getReciever() {
            return this.model;
        }
    }
}

