/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.spinner;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.swing.icons.GuiIcons;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public class SpinnerPanel {
    private final JComponent spinnerComponent;
    private final JComponent backgroundComponent;
    private final BooleanModel visibleModel = new BooleanModel(false);

    public SpinnerPanel(JComponent backgroundComponent) {
        this.spinnerComponent = new JPanel(new BorderLayout());
        this.spinnerComponent.add((Component)new JLabel(GuiIcons.SPINNER_ICON.getLargeIcon()), "Center");
        this.spinnerComponent.setOpaque(false);
        this.spinnerComponent.setVisible(false);
        this.backgroundComponent = backgroundComponent;
        this.visibleModel.addChangeListener(() -> GuiUtilities.invokeLater(() -> this.activateSpinner(this.visibleModel.isTrue())));
    }

    public void activate() {
        this.setActive(true);
    }

    public void deactivate() {
        this.setActive(false);
    }

    public JComponent getComponent() {
        return this.spinnerComponent;
    }

    private void activateSpinner(boolean value) {
        this.spinnerComponent.setVisible(value);
        GuiUtilities.setContainerEnabled(this.backgroundComponent, !value);
    }

    public synchronized void setActive(boolean showSpinner) {
        this.visibleModel.set(showSpinner);
    }

    public synchronized void execute(Runnable runnable) {
        try {
            this.activate();
            runnable.run();
        }
        finally {
            this.deactivate();
        }
    }
}

