/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.PlainDocument;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectDistributor;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.swing.object.IKeyListenerFactory;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.swing.object.StringFieldBuilder;
import net.anwiba.commons.swing.table.FilterableObjectTableModel;
import net.anwiba.commons.swing.table.IObjectListTableConfiguration;
import net.anwiba.commons.swing.table.IRowFilter;
import net.anwiba.commons.swing.table.ObjectListTableMessages;
import net.anwiba.commons.swing.table.ObjectListTableModel;
import net.anwiba.commons.swing.table.ObjectTable;
import net.anwiba.commons.swing.table.filter.IColumToStringConverter;
import net.anwiba.commons.swing.table.filter.ObjectListTableFilter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ObjectListTable<T>
extends ObjectTable<T> {
    private final IObjectModel<IRowFilter> rowFilterModel;
    private final IObjectListTableConfiguration<T> configuration;

    public ObjectListTable(IObjectListTableConfiguration<T> configuration, List<T> list) {
        super(configuration, new FilterableObjectTableModel<T>(new ObjectListTableModel<T>(list, configuration.getColumnValueProviders(), configuration.getColumnValueAdaptors(), configuration.getColumnClassProvider())));
        this.configuration = configuration;
        final FilterableObjectTableModel tableModel = (FilterableObjectTableModel)this.getTableModel();
        ObjectModel rowFilterModel = new ObjectModel();
        rowFilterModel.addChangeListener(new IChangeableObjectListener((IObjectModel)rowFilterModel){
            final /* synthetic */ IObjectModel val$rowFilterModel;
            {
                this.val$rowFilterModel = iObjectModel;
            }

            public void objectChanged() {
                tableModel.setRowFilter((IRowFilter)this.val$rowFilterModel.get());
            }
        });
        this.rowFilterModel = rowFilterModel;
        ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!this.getSortStateModel().isTrue());
        this.getSortStateModel().addChangeListener(new IChangeableObjectListener(){

            public void objectChanged() {
                ((ObjectListTableModel)tableModel.getObjectTableModel()).setChangeable(!ObjectListTable.this.getSortStateModel().isTrue());
            }
        });
    }

    public IObjectModel<IRowFilter> getRowFilterModel() {
        return this.rowFilterModel;
    }

    @Override
    public JComponent getComponent() {
        if (this.configuration.isTextFieldEnable() || !this.configuration.getTextFieldActionConfiguration().isEmpty() || this.configuration.getAccessoryHeaderPanelFactory() != null || this.configuration.getAccessoryFooterPanelFactory() != null) {
            IObjectField<String> stringField = this.createStringField();
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new BorderLayout());
            if (stringField != null || this.configuration.getAccessoryHeaderPanelFactory() != null) {
                JPanel headPane = new JPanel();
                headPane.setLayout(new BorderLayout(0, 0));
                Optional.of(stringField).consume(c -> headPane.add((Component)c.getComponent(), "Center"));
                if (this.configuration.getAccessoryHeaderPanelFactory() != null) {
                    headPane.add((Component)this.configuration.getAccessoryHeaderPanelFactory().create(this.getTableModel()), "East");
                }
                contentPane.add((Component)headPane, "North");
            }
            contentPane.add("Center", super.getComponent());
            if (this.configuration.getAccessoryFooterPanelFactory() != null) {
                contentPane.add((Component)this.configuration.getAccessoryFooterPanelFactory().create(this.getTableModel()), "South");
            }
            return contentPane;
        }
        IObjectDistributor rowFilterDistributor = this.configuration.getRowFilterDistributor();
        if (rowFilterDistributor != null) {
            IObjectModel<IRowFilter> rowFilterModel = this.getRowFilterModel();
            IChangeableObjectListener listener = () -> {
                if (rowFilterDistributor.isEmpty()) {
                    rowFilterModel.set(null);
                    return;
                }
                rowFilterModel.set(new ObjectListTableFilter((IAcceptor)rowFilterDistributor.get()));
            };
            rowFilterDistributor.addChangeListener(listener);
            listener.objectChanged();
        }
        return super.getComponent();
    }

    protected IObjectField<String> createStringField() {
        if (!this.configuration.isTextFieldEnable() && this.configuration.getTextFieldActionConfiguration().isEmpty()) {
            return null;
        }
        StringFieldBuilder builder = new StringFieldBuilder();
        this.configuration.getTextFieldActionConfiguration().getFactories().forEach(f -> builder.addActionFactory((model, document, enabledDistributor, clearBlock) -> f.create(this.getTableModel(), this.getSelectionIndexModel(), this.getSelectionModel(), enabledDistributor, (IObjectModel<String>)model, (IBlock<RuntimeException>)clearBlock)));
        builder.addClearAction(ObjectListTableMessages.clear);
        Optional.of(this.configuration.getTextFieldKeyListenerFactory()).consume(f -> builder.setKeyListenerFactory(new IKeyListenerFactory<String>(){

            @Override
            public KeyListener create(IObjectModel<String> model, PlainDocument document, IBlock<RuntimeException> clearBlock) {
                return f.create(ObjectListTable.this.getTableModel(), ObjectListTable.this.getSelectionIndexModel(), ObjectListTable.this.getSelectionModel(), model, clearBlock);
            }
        }));
        builder.setColumns(40);
        IObjectField<String> stringField = builder.build();
        IObjectModel model = stringField.getModel();
        if (this.configuration.isFilterable()) {
            IObjectModel<IRowFilter> rowFilterModel = this.getRowFilterModel();
            IColumToStringConverter filterToStringConverter = this.configuration.getRowFilterToStringConverter();
            IObjectDistributor rowFilterDistributor = this.configuration.getRowFilterDistributor();
            if (filterToStringConverter != null && rowFilterDistributor != null) {
                IChangeableObjectListener listener = () -> {
                    String value = (String)model.get();
                    if (StringUtilities.isNullOrTrimmedEmpty((String)value) && rowFilterDistributor.isEmpty()) {
                        rowFilterModel.set(null);
                    } else if (!StringUtilities.isNullOrTrimmedEmpty((String)value) && rowFilterDistributor.isEmpty()) {
                        rowFilterModel.set(new ObjectListTableFilter(value, filterToStringConverter));
                    } else if (StringUtilities.isNullOrTrimmedEmpty((String)value) && !rowFilterDistributor.isEmpty()) {
                        rowFilterModel.set(new ObjectListTableFilter((IAcceptor)rowFilterDistributor.get()));
                    } else {
                        rowFilterModel.set(new ObjectListTableFilter(value, filterToStringConverter, (IAcceptor)rowFilterDistributor.get()));
                    }
                };
                rowFilterDistributor.addChangeListener(listener);
                model.addChangeListener(listener);
                listener.objectChanged();
            } else if (filterToStringConverter != null && rowFilterDistributor == null) {
                IChangeableObjectListener listener = () -> {
                    String value = (String)model.get();
                    if (StringUtilities.isNullOrTrimmedEmpty((String)value)) {
                        rowFilterModel.set(null);
                        return;
                    }
                    rowFilterModel.set(new ObjectListTableFilter(value, filterToStringConverter));
                };
                model.addChangeListener(listener);
                listener.objectChanged();
            } else if (filterToStringConverter == null && rowFilterDistributor != null) {
                IChangeableObjectListener listener = () -> {
                    if (rowFilterDistributor.isEmpty()) {
                        rowFilterModel.set(null);
                        return;
                    }
                    rowFilterModel.set(new ObjectListTableFilter((IAcceptor)rowFilterDistributor.get()));
                };
                rowFilterDistributor.addChangeListener(listener);
                listener.objectChanged();
            }
        }
        return stringField;
    }
}

