/*
 * #%L
 * anwiba commons swing
 * %%
 * Copyright (C) 2007 - 2016 Andreas Bartels
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */
package net.anwiba.commons.swing.utilities;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtilities {

  public static void setTableCellRenderer(
      final JTable table,
      final TableModel tableModel,
      final TableCellRenderer cellRenderer) {
    final TableColumnModel columnModel = table.getColumnModel();
    for (int i = 0; i < tableModel.getColumnCount(); i++) {
      final TableColumn column = columnModel.getColumn(i);
      column.setCellRenderer(cellRenderer);
    }
  }

  public static int getColumnWithFor(final Class<?> columnClass) {
    if (columnClass == null) {
      return 200;
    }
    if (Boolean.class.isAssignableFrom(columnClass)) {
      return 50;
    }
    if (Number.class.isAssignableFrom(columnClass)) {
      return 100;
    }
    return 200;
  }

}
