/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.anwiba.commons.swing.date.event.DateSelectionEvent;
import net.anwiba.commons.swing.date.event.DateSelectionListener;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;

class DatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Color gridColor = Color.lightGray;
    int era = -1;
    int dayOfWeek = -1;
    int day = -1;
    int month = -1;
    int year = -1;
    boolean isActive = false;
    JLabel dayLabel = null;
    boolean isSelected = false;
    static LocalDateTime currentDay = UserDateTimeUtilities.now().toLocalDateTime();

    DatePanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createLineBorder(this.gridColor));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Object source = event.getSource();
                if (source == DatePanel.this && !DatePanel.this.isSelected) {
                    if (!DatePanel.this.isActive) {
                        DatePanel.this.isActive = true;
                    }
                    DatePanel.this.setSelected(true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object source = event.getSource();
                if (source == DatePanel.this && !DatePanel.this.isSelected) {
                    DatePanel.this.setSelected(true);
                }
            }
        });
        this.dayLabel = new JLabel();
        this.dayLabel.setText(null);
        this.dayLabel.setForeground(Color.black);
        this.add((Component)this.dayLabel, "North");
    }

    void setSelected(boolean isSelected) {
        if (isSelected && this.isActive) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.fireSelectionOccured();
            }
        } else if (this.isSelected) {
            this.isSelected = false;
            this.fireDeselectionOccured();
        }
        this.toColor();
    }

    private void toColor() {
        if (this.isSelected) {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
            this.dayLabel.setForeground(Color.red);
        } else if (currentDay.getYear() == this.year && currentDay.getMonthValue() == this.month && currentDay.getDayOfMonth() == this.day) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.dayLabel.setForeground(Color.blue);
        } else {
            this.setBorder(BorderFactory.createLineBorder(this.gridColor));
            this.dayLabel.setForeground(Color.black);
        }
    }

    void setGridColor(Color gridColor) {
        if (gridColor == null || this.gridColor == gridColor) {
            return;
        }
        this.gridColor = gridColor;
        this.toColor();
    }

    void setDate(GregorianCalendar date) {
        this.setDate(date, date == null);
    }

    void setDate(GregorianCalendar date, boolean isActive) {
        if (date != null && date.get(1) == this.year && date.get(2) == this.month && date.get(5) == this.day) {
            return;
        }
        if (date == null && this.year == -1 && this.month == -1 && this.day == -1 && this.dayOfWeek == -1) {
            return;
        }
        if (this.isSelected) {
            this.isSelected = false;
            this.fireDeselectionOccured();
        }
        if (date == null) {
            this.era = -1;
            this.dayOfWeek = -1;
            this.day = -1;
            this.month = -1;
            this.year = -1;
            this.isActive = false;
            this.dayLabel.setText(null);
        } else {
            this.isActive = isActive;
            this.era = date.get(0);
            this.dayOfWeek = date.get(7);
            this.day = date.get(5);
            this.month = date.get(2);
            this.year = this.era == 1 ? date.get(1) : (date.get(1) - 1) * -1;
            this.dayLabel.setText(Integer.toString(this.day));
        }
        this.toColor();
    }

    int getERA() {
        return this.era;
    }

    int getYear() {
        return this.year;
    }

    int getMonth() {
        return this.month;
    }

    int getDay() {
        return this.day;
    }

    Date getDate() {
        if (this.era == -1 && this.day == -1 && this.month == -1 && this.year == -1) {
            return null;
        }
        return new GregorianCalendar(this.year, this.month, this.day).getTime();
    }

    protected void fireSelectionOccured() {
        Object[] listeners = this.listenerList.getListenerList();
        DateSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DateSelectionListener.class) continue;
            if (e == null) {
                e = new DateSelectionEvent(this, this.getDate());
            }
            ((DateSelectionListener)listeners[i + 1]).selectionOccurred(e);
        }
    }

    protected void fireDeselectionOccured() {
        Object[] listeners = this.listenerList.getListenerList();
        DateSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DateSelectionListener.class) continue;
            if (e == null) {
                e = new DateSelectionEvent(this, this.getDate());
            }
            ((DateSelectionListener)listeners[i + 1]).deselectionOccurred(e);
        }
    }

    public void addDaySelectionListener(DateSelectionListener l) {
        this.listenerList.add(DateSelectionListener.class, l);
    }

    public void removeDaySelectionListener(DateSelectionListener l) {
        this.listenerList.remove(DateSelectionListener.class, l);
    }
}

