/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageTypeVisitor;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.preferences.DummyPreferences;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogResult;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.IAdditionalActionFactory;
import net.anwiba.commons.swing.dialog.IDataStateVisitor;
import net.anwiba.commons.swing.dialog.IDialogResult;
import net.anwiba.commons.swing.dialog.IDialogTypeVisitor;
import net.anwiba.commons.swing.dialog.MessagePanel;
import net.anwiba.commons.swing.preference.IWindowPreferences;
import net.anwiba.commons.swing.preference.WindowPreferences;
import net.anwiba.commons.swing.preference.WindowPrefereneceUpdatingListener;
import net.anwiba.commons.swing.utilities.GuiUtilities;

public abstract class AbstractDialog
extends JDialog {
    private static ILogger logger = Logging.getLogger((String)AbstractDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private Action applyAction;
    private final JPanel buttomPanel = new JPanel();
    private final JPanel contentContainerPanel = new JPanel(new GridLayout(1, 1));
    private final JPanel detailContainerPanel = new JPanel(new GridLayout(1, 1));
    private Container contentPane;
    private final IObjectModel<IDialogResult> dialogResultModel = new ObjectModel((Object)DialogResult.NONE);
    private boolean isDetailsVisible;
    private final MessagePanel messagePanel;
    private AbstractAction okAction;
    private Action tryAction;
    private final IWindowPreferences windowPreferences;
    private final WindowPrefereneceUpdatingListener updater;
    private AbstractAction cancelAction;
    private final IFunction<String, String, RuntimeException> actionButtonTextFactory;
    private final Dimension preferdSize;
    private final IObjectModel<DataState> dataStateModel;

    public AbstractDialog(Window owner, String title, IMessage message, Icon icon, DialogType dialogType, boolean modal) {
        this(owner, new WindowPreferences((IPreferences)new DummyPreferences(new String[0])), null, title, message, icon, true, dialogType, (IFunction<String, String, RuntimeException>)((IFunction)s -> s), Collections.emptyList(), (IObjectModel<DataState>)new ObjectModel(), modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS, null);
    }

    public AbstractDialog(Window owner, IWindowPreferences windowPreferences, String title, IMessage message, Icon icon, DialogType dialogType, List<IAdditionalActionFactory> actionFactories, IObjectModel<DataState> dataStateModel, boolean modal) {
        this(owner, windowPreferences, null, title, message, icon, true, dialogType, (IFunction<String, String, RuntimeException>)((IFunction)s -> s), actionFactories, dataStateModel, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS, null);
    }

    public AbstractDialog(Window owner, IWindowPreferences windowPreferences, String title, IMessage message, Icon icon, DialogType dialogType, List<IAdditionalActionFactory> actionFactories, IObjectModel<DataState> dataStateModel, Dialog.ModalityType modalityType) {
        this(owner, windowPreferences, null, title, message, icon, true, dialogType, (IFunction<String, String, RuntimeException>)((IFunction)s -> s), actionFactories, dataStateModel, modalityType, null);
    }

    public AbstractDialog(Window owner, IWindowPreferences windowPreferences, Dimension preferdSize, String title, IMessage message, Icon icon, boolean isMessagePanelEnabled, DialogType dialogType, IFunction<String, String, RuntimeException> actionButtonTextFactory, List<IAdditionalActionFactory> additionalActionFactories, IObjectModel<DataState> dataStateModel, Dialog.ModalityType modalityType, Dialog.ModalExclusionType modalExclusionType) {
        super(owner, title, modalityType);
        this.dataStateModel = dataStateModel;
        Optional.of((Object)((Object)modalExclusionType)).consume(t -> this.setModalExclusionType(modalExclusionType));
        this.preferdSize = preferdSize;
        Ensure.ensureArgumentNotNull((Object)windowPreferences);
        this.windowPreferences = windowPreferences;
        this.updater = new WindowPrefereneceUpdatingListener(this, this.windowPreferences);
        this.messagePanel = isMessagePanelEnabled && message != null ? new MessagePanel(message, icon) : null;
        this.actionButtonTextFactory = actionButtonTextFactory;
        this.setIcon(icon);
        this.createView(dialogType, additionalActionFactories, dataStateModel, message);
    }

    protected IObjectModel<DataState> getDataStateModel() {
        return this.dataStateModel;
    }

    @Override
    public void setVisible(boolean value) {
        GuiUtilities.invokeLater(() -> {
            if (value) {
                this.locate();
            }
            super.setVisible(value);
        });
    }

    public void locate() {
        this.removeComponentListener(this.updater);
        this.removeWindowListener(this.updater);
        try {
            Rectangle bounds = this.windowPreferences.getBounds();
            if (bounds == null) {
                if (this.preferdSize == null) {
                    this.pack();
                } else {
                    this.setSize(this.preferdSize);
                }
                GuiUtilities.center(this);
            } else {
                this.setBounds(bounds);
            }
        }
        finally {
            this.addComponentListener(this.updater);
            this.addWindowListener(this.updater);
        }
    }

    protected void checkButton(DataState dataState) {
        dataState.accept(new IDataStateVisitor(){

            @Override
            public void visitInvalide() {
                AbstractDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitModified() {
                AbstractDialog.this.setChangeButtonsEnabled(true, true);
            }

            @Override
            public void visitUnknown() {
                AbstractDialog.this.setChangeButtonsEnabled(false, false);
            }

            @Override
            public void visitValide() {
                AbstractDialog.this.setChangeButtonsEnabled(false, true);
            }
        });
    }

    protected final void setChangeButtonsEnabled(boolean isApplyEnabled, boolean isOkEnabled) {
        this.setApplyEnabled(isApplyEnabled);
        this.setOkEnabled(isOkEnabled);
    }

    protected final void createView(DialogType dialogType, List<IAdditionalActionFactory> additionalActionFactories, IObjectModel<DataState> dataStateModel, IMessage message) {
        Action[] actions;
        this.contentPane = this.createContentPane(message);
        this.contentContainerPanel.add(this.contentPane);
        this.buttomPanel.setLayout(new FlowLayout(2));
        for (Action action : actions = this.getActions(dialogType, this.dialogResultModel, additionalActionFactories, dataStateModel)) {
            JButton button = new JButton(action);
            this.buttomPanel.add(button);
        }
        this.buttomPanel.setMinimumSize(new Dimension(100, 30));
        this.buttomPanel.setMaximumSize(new Dimension(1000, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.contentContainerPanel, "Center");
        panel.add((Component)this.detailContainerPanel, "South");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        if (this.messagePanel != null) {
            this.messagePanel.setMinimumSize(new Dimension(0, 60));
            mainPanel.add("North", this.messagePanel);
        }
        mainPanel.add("Center", panel);
        mainPanel.add("South", this.buttomPanel);
        super.setMinimumSize(new Dimension(200, 120));
        super.setContentPane(mainPanel);
    }

    protected JPanel createContentPane(IMessage message) {
        return new JPanel();
    }

    protected Action[] getActions(DialogType dialogType, IObjectModel<IDialogResult> resultModel, List<IAdditionalActionFactory> additionalActionFactories, IObjectModel<DataState> dataStateModel) {
        IDialogTypeVisitor<Action[]> visitor = new IDialogTypeVisitor<Action[]>(){

            @Override
            public Action[] visitCancelApplyOk() {
                Action[] actions = new Action[]{AbstractDialog.this.getCancelAction(), AbstractDialog.this.getApplyAction(), AbstractDialog.this.getOkAction()};
                return actions;
            }

            @Override
            public Action[] visitCancelOk() {
                Action[] actions = new Action[]{AbstractDialog.this.getCancelAction(), AbstractDialog.this.getOkAction()};
                return actions;
            }

            @Override
            public Action[] visitCancelTryOk() {
                Action[] actions = new Action[]{AbstractDialog.this.getCancelAction(), AbstractDialog.this.getTryAction(), AbstractDialog.this.getOkAction()};
                return actions;
            }

            @Override
            public Action[] visitClose() {
                Action[] actions = new Action[]{AbstractDialog.this.getCloseAction()};
                return actions;
            }

            @Override
            public Action[] visitOk() {
                Action[] actions = new Action[]{AbstractDialog.this.getOkAction()};
                return actions;
            }

            @Override
            public Action[] visitCloseDetails() {
                Action[] actions = new Action[]{AbstractDialog.this.getCloseAction(), AbstractDialog.this.getDetailsAction()};
                return actions;
            }

            @Override
            public Action[] visitNone() {
                Action[] actions = new Action[]{};
                return actions;
            }

            @Override
            public Action[] visitYesNo() {
                Action[] actions = new Action[]{AbstractDialog.this.getYesAction(), AbstractDialog.this.getNoAction()};
                return actions;
            }

            @Override
            public Action[] visitCancel() {
                Action[] actions = new Action[]{AbstractDialog.this.getCancelAction()};
                return actions;
            }
        };
        LinkedList<Action> actions = new LinkedList<Action>();
        for (IAdditionalActionFactory actionFactory : additionalActionFactories) {
            actions.add(actionFactory.create(resultModel, dataStateModel, (IBlock<RuntimeException>)((IBlock)() -> this.setVisible(false))));
        }
        actions.addAll(Arrays.asList(dialogType.accept(visitor)));
        return (Action[])actions.stream().toArray(Action[]::new);
    }

    public final Action getApplyAction() {
        if (this.applyAction == null) {
            this.applyAction = new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.APPLY)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        if (AbstractDialog.this.apply()) {
                            AbstractDialog.this.getDataStateModel().set((Object)DataState.VALIDE);
                        }
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
            this.applyAction.setEnabled(false);
        }
        return this.applyAction;
    }

    public final Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.CANCEL)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        if (AbstractDialog.this.cancel()) {
                            AbstractDialog.this.dialogResultModel.set((Object)DialogResult.CANCEL);
                            AbstractDialog.this.close();
                        }
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
        }
        return this.cancelAction;
    }

    public final AbstractAction getCloseAction() {
        return new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.CLOSE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.NONE);
                AbstractDialog.this.close();
            }
        };
    }

    @Override
    public final Container getContentPane() {
        return this.contentPane;
    }

    public final Action getDetailsAction() {
        return new AbstractAction(DialogMessages.OPEN_DETAILS){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Component detailsComponent = AbstractDialog.this.getDetailsComponent();
                if (AbstractDialog.this.isDetailsVisible) {
                    if (detailsComponent != null) {
                        AbstractDialog.this.getDetailContainerPanel().removeAll();
                        AbstractDialog.this.pack();
                    }
                    ((JButton)e.getSource()).setText(DialogMessages.OPEN_DETAILS);
                    AbstractDialog.this.isDetailsVisible = false;
                    return;
                }
                if (detailsComponent != null) {
                    AbstractDialog.this.getDetailContainerPanel().add(detailsComponent);
                    AbstractDialog.this.pack();
                }
                ((JButton)e.getSource()).setText(DialogMessages.CLOSE_DETAILS);
                AbstractDialog.this.isDetailsVisible = true;
            }
        };
    }

    public final Action getNoAction() {
        return new AbstractAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.NO)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.NO);
                AbstractDialog.this.close();
            }
        };
    }

    protected final Action getOkAction() {
        return this.getOkAction((String)this.actionButtonTextFactory.execute((Object)DialogMessages.OK));
    }

    protected final Action getOkAction(String title) {
        if (this.okAction == null) {
            this.okAction = new AbstractAction(title){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        if (!AbstractDialog.this.apply()) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                    AbstractDialog.this.dialogResultModel.set((Object)DialogResult.OK);
                    AbstractDialog.this.close();
                }
            };
        }
        return this.okAction;
    }

    public final IDialogResult getResult() {
        return (IDialogResult)this.dialogResultModel.get();
    }

    public final Action getTryAction() {
        if (this.tryAction == null) {
            this.tryAction = new AbstractAction(DialogMessages.TRY){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        AbstractDialog.this.tryOut();
                    }
                    catch (Exception exception) {
                        logger.log(ILevel.ERROR, "", (Throwable)exception);
                    }
                }
            };
            this.tryAction.setEnabled(false);
        }
        return this.tryAction;
    }

    public final Action getYesAction() {
        return new AbstractAction(DialogMessages.YES){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dialogResultModel.set((Object)DialogResult.YES);
                AbstractDialog.this.close();
            }
        };
    }

    protected final void setApplyEnabled(boolean isEnabled) {
        if (this.applyAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.applyAction, isEnabled));
        }
    }

    @Override
    public final void setContentPane(final Container contentPane) {
        if (this.contentPane == contentPane) {
            return;
        }
        this.contentPane = contentPane;
        final JPanel containerPanel = this.contentContainerPanel;
        GuiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                containerPanel.removeAll();
                containerPanel.add(contentPane);
                if (!containerPanel.isVisible()) {
                    return;
                }
                containerPanel.validate();
                containerPanel.repaint();
            }
        });
    }

    public final void setMessage(IMessage message) {
        if (this.messagePanel == null) {
            if (message != null) {
                logger.log(this.getLevel(message.getMessageType()), message.getText(), message.getThrowable());
            }
            return;
        }
        GuiUtilities.invokeLater(() -> this.messagePanel.setMessage(message));
    }

    private ILevel getLevel(MessageType messageType) {
        IMessageTypeVisitor<ILevel> visitor = new IMessageTypeVisitor<ILevel>(){

            public ILevel visitInfo() {
                return ILevel.INFO;
            }

            public ILevel visitWarning() {
                return ILevel.WARNING;
            }

            public ILevel visitError() {
                return ILevel.ERROR;
            }

            public ILevel visitDefault() {
                return ILevel.INFO;
            }

            public ILevel visitQuery() {
                throw new IllegalStateException();
            }
        };
        return (ILevel)messageType.accept((IMessageTypeVisitor)visitor);
    }

    public final void setIcon(Icon icon) {
        if (this.messagePanel == null) {
            return;
        }
        GuiUtilities.invokeLater(() -> this.messagePanel.setIcon(icon));
    }

    public final void setOkEnabled(boolean isEnabled) {
        if (this.okAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.okAction, isEnabled));
        }
    }

    public final void setTryEnabled(boolean isEnabled) {
        if (this.tryAction != null) {
            GuiUtilities.invokeLater(new ActionEnableRunner(this.tryAction, isEnabled));
        }
    }

    protected abstract boolean apply();

    protected abstract boolean tryOut();

    protected abstract boolean cancel();

    protected Component getDetailsComponent() {
        return null;
    }

    protected final JPanel getDetailContainerPanel() {
        return this.detailContainerPanel;
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
        Optional.of((Object)this.getOwner()).consume(w -> w.toFront());
    }

    public static final class ActionEnableRunner
    implements Runnable {
        private final Action action;
        private final boolean isEnabled;

        public ActionEnableRunner(Action action, boolean isEnabled) {
            this.action = action;
            this.isEnabled = isEnabled;
        }

        @Override
        public void run() {
            this.action.setEnabled(this.isEnabled);
        }
    }
}

