/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.preferences.IPreferences;
import net.anwiba.commons.swing.component.GridBagLayoutComponentBuilder;
import net.anwiba.commons.swing.dialog.DataState;
import net.anwiba.commons.swing.dialog.IContentPaneFactory;
import net.anwiba.commons.swing.dialog.pane.AbstractContentPane;
import net.anwiba.commons.swing.dialog.pane.IContentPanel;
import net.anwiba.commons.swing.object.IObjectField;
import net.anwiba.commons.utilities.validation.IValidationResult;

public class ContentPaneFactoryBuilder {
    GridBagLayoutComponentBuilder componentBuilder = new GridBagLayoutComponentBuilder();
    List<IObjectField<?>> objectFields = new ArrayList();

    public ContentPaneFactoryBuilder header(String text) {
        this.componentBuilder.header(text);
        return this;
    }

    public ContentPaneFactoryBuilder label(String text) {
        this.componentBuilder.newlineAndLabel(text);
        return this;
    }

    public ContentPaneFactoryBuilder add(IObjectField<?> field) {
        this.objectFields.add(field);
        this.componentBuilder.add(field.getComponent());
        return this;
    }

    public ContentPaneFactoryBuilder add(JComponent component) {
        this.componentBuilder.add(component);
        return this;
    }

    public ContentPaneFactoryBuilder add(JComponent component, int with) {
        this.componentBuilder.add(component, with);
        return this;
    }

    public ContentPaneFactoryBuilder newline() {
        this.componentBuilder.newline();
        return this;
    }

    public ContentPaneFactoryBuilder emptyLine() {
        this.componentBuilder.emptyLine();
        return this;
    }

    public ContentPaneFactoryBuilder setBorder(Border border) {
        this.componentBuilder.setBorder(border);
        return this;
    }

    public IContentPaneFactory build() {
        return new IContentPaneFactory(){

            @Override
            public IContentPanel create(Window owner, IPreferences preferences, IObjectModel<DataState> dataStateModel) {
                final JComponent component = ContentPaneFactoryBuilder.this.componentBuilder.build();
                return new AbstractContentPane(dataStateModel){
                    JComponent contentComponent;

                    @Override
                    public JComponent getComponent() {
                        if (this.contentComponent == null) {
                            this.contentComponent = component;
                            Map originalValues = ContentPaneFactoryBuilder.this.objectFields.stream().collect(Collectors.toConcurrentMap(f -> f, f -> f.getModel().get()));
                            IChangeableObjectListener listener = () -> {
                                for (IObjectField<?> field : ContentPaneFactoryBuilder.this.objectFields) {
                                    IValidationResult validationResult = (IValidationResult)field.getValidationResultDistributor().get();
                                    if (validationResult.isValid()) continue;
                                    this.getMessageModel().set((Object)Message.error((String)validationResult.getMessage()).build());
                                    this.getDataStateModel().set((Object)DataState.INVALIDE);
                                    return;
                                }
                                this.getMessageModel().set(null);
                                for (IObjectField<?> field : ContentPaneFactoryBuilder.this.objectFields) {
                                    if (Objects.equals(originalValues.get(field), field.getModel().get())) continue;
                                    this.getDataStateModel().set((Object)DataState.MODIFIED);
                                    return;
                                }
                                this.getDataStateModel().set((Object)DataState.VALIDE);
                            };
                            ContentPaneFactoryBuilder.this.objectFields.forEach(f -> {
                                f.getModel().addChangeListener(listener);
                                f.getValidationResultDistributor().addChangeListener(listener);
                            });
                        }
                        return new JScrollPane(this.contentComponent);
                    }
                };
            }
        };
    }
}

