/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.dialog.exception;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.swing.dialog.DialogMessages;
import net.anwiba.commons.swing.dialog.DialogType;
import net.anwiba.commons.swing.dialog.MessageDialog;
import net.anwiba.commons.swing.icons.GuiIcons;

public class ExceptionDialog
extends MessageDialog {
    private static final long serialVersionUID = 1L;
    private final IMessage exceptionMessage;
    private JScrollPane detailsPanel;

    public ExceptionDialog(Window owner, Throwable throwable) {
        this(owner, Message.error((String)throwable.getClass().getSimpleName()).description(throwable.getMessage()).throwable(throwable).build());
    }

    public ExceptionDialog(Window owner, IMessage message) {
        this(owner, DialogMessages.ERROR, message);
    }

    public ExceptionDialog(Window owner, String title, IMessage message) {
        super(owner, title, message, GuiIcons.EMPTY_ICON.getLargeIcon(), DialogType.CLOSE_DETIALS);
        this.exceptionMessage = message;
    }

    @Override
    protected Component getDetailsComponent() {
        if (this.detailsPanel == null) {
            JTextArea textArea = new JTextArea();
            this.detailsPanel = new JScrollPane(textArea);
            textArea.setEditable(false);
            textArea.setLineWrap(false);
            textArea.setRows(15);
            textArea.setColumns(40);
            textArea.append(Message.toDetailInfo((Throwable)this.exceptionMessage.getThrowable()));
        }
        return this.detailsPanel;
    }
}

